package com.gingersoft.gsa.cloud.main.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/03/2020 09:53
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface NewlyAddedContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {

    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        /**
         * 添加時段
         * @param requestBody
         * @return
         */
        Observable<BaseResult> addPeriod(RequestBody requestBody);

        /**
         * 修改時段
         * @param requestBody
         * @return
         */
        Observable<BaseResult> updatePeriod(RequestBody requestBody);

        /**
         * 刪除時段
         * @param id 時段id
         * @return
         */
        Observable<BaseResult> deletePeriod(int id);

        /**
         * 新增餐種
         * @param requestBody
         * @return
         */
        Observable<BaseResult> addSummary(RequestBody requestBody);

        /**
         * 修改餐種
         * @param requestBody
         * @return
         */
        Observable<BaseResult> updateSummary(RequestBody requestBody);
    }
}
