package com.gingersoft.gsa.cloud.main.mvp.model.service;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface ExpandListService {

    @GET("restaurant/ext/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getExpandList(@Query("restaurantId") int restaurantId);

    @Headers({"Domain-Name: system_url"})
    @POST("restaurantExt/batchUpdate"  + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateExpandInfo(@Body RequestBody requestBody);

}
