package com.gingersoft.gsa.cloud.main.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.main.mvp.contract.SalesContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DailyReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DeliveryLineChartBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DeliveryPersonnelReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SalesFoodsBean;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/23/2020 16:21
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class SalesPresenter extends BasePresenter<SalesContract.Model, SalesContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public SalesPresenter(SalesContract.Model model, SalesContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void getSalesReportInfo(String restaurantId, String startTime, String endTime) {
        Map<String, Object> map = new HashMap<>();
        map.put("restaurantId", restaurantId);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        mModel.getSalesReportInfo(map)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<SalesFoodsBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull SalesFoodsBean info) {
                        if (info != null && info.isSuccess()) {
                            if (info.getData() != null) {
                                mRootView.loadInfo(info.getData().getSalesRanking());
                            }
                        } else {
                            mRootView.showMessage("銷售信息獲取失敗");
                        }
                    }
                });
    }

    public void getDeliveryOrderCurveInfo(String restaurantId, String startTime, String endTime) {
        Map<String, Object> map = new HashMap<>();
        map.put("restaurantId", restaurantId);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        mModel.getDeliveryOrderCurveInfo(map)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<DeliveryLineChartBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull DeliveryLineChartBean info) {
                        if (info != null && info.isSuccess()) {
                            mRootView.loadDeliveryLineChart(info.getData());
                        }
                    }
                });

    }

    public void getDeliveryPersonnelReport(String restaurantId, String startTime, String endTime) {
        Map<String, Object> map = new HashMap<>();
        map.put("restaurantId", restaurantId);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        mModel.getDeliveryPersonnelReport(map)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<DeliveryPersonnelReportBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull DeliveryPersonnelReportBean info) {
                        if (info != null && info.isSuccess()) {
                            if (info.getData() != null) {
                                List<DailyReportBean> dailyReportBeans = new ArrayList<>();
                                dailyReportBeans.add(new DailyReportBean("姓名", "總單量", "平均每單用時(min)", "金額"));
                                for (DeliveryPersonnelReportBean.DataBean listBean : info.getData()) {
                                    dailyReportBeans.add(new DailyReportBean(listBean.getSenderName(), listBean.getNum() + "", "" + listBean.getDeliveredTime(), listBean.getAmount() + ""));
                                }
//                                dailyReportBeans.add(new DailyReportBean("合計", info.getData().getBillNumSum() + "", "100", info.getData().getAmountSum() + ""));
                                mRootView.loadDeliveryPersonnelReport(dailyReportBeans);
                            }
                        } else {

                        }
                    }
                });

    }

}
