package com.gingersoft.gsa.cloud.main.mvp.ui.activity

import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.gingersoft.gsa.cloud.common.config.LoganConfig
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager
import com.gingersoft.gsa.cloud.common.utils.FileUtils
import com.gingersoft.gsa.cloud.main.R
import kotlinx.android.synthetic.main.activity_look_log.*
import java.io.BufferedReader
import java.io.File
import java.io.FileInputStream
import java.io.InputStreamReader

class LookLogActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_look_log)
        log_top_bar.setTitle(RestaurantInfoManager.newInstance().getRestaurantName())
        log_top_bar.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener { onBackPressed() }
        log_top_bar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color))

        val file = File(FileUtils.ERRORLOG_PATH)

//        val file = File((getExternalFilesDir(null)!!.absolutePath
//                + File.separator + LoganConfig.FILE_NAME))
        val files = file.listFiles()

        files?.let {
            val ml = ArrayList<File>()
            for (i in files.size - 1 downTo 0) {
                ml.add(files[i])
            }
            rv_log.layoutManager = LinearLayoutManager(this)
            val logAdapter = LogAdapter(ml)
            logAdapter.setOnItemClickListener { _, _, position ->
                scroll_log.visibility = View.VISIBLE
                var x = ml[position]
                if (!x.isDirectory) {
                    val fileInputStream = FileInputStream(x)
                    val inputStreamReader = InputStreamReader(fileInputStream)
                    val bufferedReader = BufferedReader(inputStreamReader)
                    var line: String?
                    var content = ""
                    do {
                        line = bufferedReader.readLine()
                        if (line != null) {
                            content += line
                        } else {
                            break
                        }
                    } while (true)
                    tv_log_details.text = content
//                    tv_log_details.movementMethod = ScrollingMovementMethod.getInstance()
                    fileInputStream.close()
                }
            }
            rv_log.adapter = logAdapter
        }
    }

    class LogAdapter(files: MutableList<File>) : BaseQuickAdapter<File, BaseViewHolder>(R.layout.layout_log_name, files) {
        override fun convert(holder: BaseViewHolder, item: File) {
            holder.setText(R.id.tv_log_name, item.name)
        }
    }

    override fun onBackPressed() {
        if (scroll_log.visibility == View.VISIBLE) {
            scroll_log.visibility = View.GONE
        } else {
            super.onBackPressed()
        }
    }
}
