package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DailyReportBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class DailyBusinessAdapter extends BaseQuickAdapter<DailyReportBean, BaseViewHolder> {
    private int spanCount;
    private Context context;
    private GradientDrawable drawable;

    private boolean isPrint;

    public DailyBusinessAdapter(Context context, @Nullable List<DailyReportBean> data) {
        this(context, data, 4, false);
    }

    public DailyBusinessAdapter(Context context, @Nullable List<DailyReportBean> data, int spanCount, boolean isPrint) {
        super(R.layout.item_public_report, data);
        this.spanCount = spanCount;
        this.context = context;
        this.isPrint = isPrint;
        drawable = new GradientDrawable();
        drawable.setCornerRadii(new float[]{0, 0, 8, 8});
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, DailyReportBean dailyReportBean) {
        if (spanCount == 3) {
            baseViewHolder.setGone(R.id.tv_public_three, true);
        } else {
            baseViewHolder.setGone(R.id.tv_public_three, false);
        }
        baseViewHolder.setText(R.id.tv_public_one, dailyReportBean.getType());
        baseViewHolder.setText(R.id.tv_public_two, dailyReportBean.getNum());
        baseViewHolder.setText(R.id.tv_public_three, dailyReportBean.getProportion());
        baseViewHolder.setText(R.id.tv_public_four, dailyReportBean.getAmount());

        if (isPrint) {
            ((TextView) baseViewHolder.getView(R.id.tv_public_one)).setTextSize(24);
            ((TextView) baseViewHolder.getView(R.id.tv_public_two)).setTextSize(24);
            ((TextView) baseViewHolder.getView(R.id.tv_public_three)).setTextSize(24);
            ((TextView) baseViewHolder.getView(R.id.tv_public_four)).setTextSize(24);
            baseViewHolder.setBackgroundColor(R.id.horizontal_dividing_line, R.color.black);
            baseViewHolder.setBackgroundColor(R.id.public_report_vertical_dividing_line1, R.color.black);
            baseViewHolder.setBackgroundColor(R.id.public_report_vertical_dividing_line2, R.color.black);
            baseViewHolder.setBackgroundColor(R.id.public_report_vertical_dividing_line3, R.color.black);
        } else {
            if (baseViewHolder.getAdapterPosition() % 2 == 0) {
                if (baseViewHolder.getAdapterPosition() == getData().size() - 1) {
                    drawable.setColor(ContextCompat.getColor(context, R.color.white));
                } else {
                    baseViewHolder.itemView.setBackgroundColor(ContextCompat.getColor(context, R.color.white));
                }
            } else {
                if (baseViewHolder.getAdapterPosition() == getData().size() - 1) {
                    drawable.setColor(ContextCompat.getColor(context, R.color.color_f9));
                } else {
                    baseViewHolder.itemView.setBackgroundColor(ContextCompat.getColor(context, R.color.color_f9));
                }
            }
        }
    }
}
