package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import android.content.Context;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodMenuEditBean;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu.multi.RadioAdapter;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/28
 * Time: 11:54
 */
public class RadioItemProvider extends FoodMenuItemProvider {

    private Context context;
    private int selectIndex;

    public RadioItemProvider(Context context) {
        this.context = context;
    }

    @Override
    public int getItemViewType() {
        return FoodMenuEditBean.EDIT_FOOD_ITEM_RADIO;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_food_menu_radio;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, FoodMenuEditBean foodMenuEditBean) {
        super.convert(baseViewHolder, foodMenuEditBean);
        RecyclerView rv = baseViewHolder.getView(R.id.rv_radio);
        rv.setLayoutManager(new GridLayoutManager(context, 2));
        RadioAdapter radioAdapter = new RadioAdapter(foodMenuEditBean.getCheckBoxList());
        radioAdapter.setOnItemChildClickListener((adapter, view, position) -> {
            radioAdapter.setCheckedIndex(position);
            radioAdapter.notifyDataSetChanged();
        });
        rv.setAdapter(radioAdapter);
    }
}
