package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu.multi;

import android.widget.CheckBox;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodMenuEditBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/28
 * Time: 16:04
 * Use:
 */
public class MultiSelectAdapter extends BaseQuickAdapter<FoodMenuEditBean.ShowClient, BaseViewHolder> {

    public MultiSelectAdapter(@Nullable List<FoodMenuEditBean.ShowClient> data) {
        super(R.layout.item_child_checkbox, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, FoodMenuEditBean.ShowClient showClient) {
        CheckBox checkBox = baseViewHolder.getView(R.id.cb_food_menu_item);
        checkBox.setText(showClient.getClientName());
        checkBox.setChecked(showClient.isChecked());
        checkBox.setOnCheckedChangeListener((buttonView, isChecked) -> showClient.setChecked(isChecked));
    }
}
