package com.joe.print.di.module;

import com.jess.arms.di.scope.FragmentScope;

import dagger.Module;
import dagger.Provides;

import com.joe.print.mvp.contract.IpPrintListActivityContract;
import com.joe.print.mvp.model.IpPrintListActivityModel;


@Module
public class IpPrintListActivityModule {
    private IpPrintListActivityContract.View view;

    /**
     * 构建IpPrintListActivityModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     *
     * @param view
     */
    public IpPrintListActivityModule(IpPrintListActivityContract.View view) {
        this.view = view;
    }

    @FragmentScope
    @Provides
    IpPrintListActivityContract.View provideIpPrintListActivityView() {
        return this.view;
    }

    @FragmentScope
    @Provides
    IpPrintListActivityContract.Model provideIpPrintListActivityModel(IpPrintListActivityModel model) {
        return model;
    }
}