package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;
import com.joe.print.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 測試頁打印
 */
public class PrintTest extends PrinterRoot {


    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, deviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String[] getPrintDatas(Context mContext, PrinterDeviceBean deviceBean) {
        String stringBuilder = "<html><body>" +
                "<p>測試打印1<p/></br>" +
                "<p>測試打印2<p/></br>" +
                "<p>測試打印3<p/></br>" +
                "<p>測試打印4<p/></br>" +
                "<p>測試打印5<p/></br>" +
                "<row>" +
                " <column>This is an item with super long name</column>" +
                " <column offset=0.6>1</column>" +
                " <column offset=last>HKD 100</column>" +
                " </row>"+
                "</body></html>";
        String[] pritContent = new String[1];
        pritContent[0] = stringBuilder;
        return pritContent;
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }


    /**
     * 獲取測試打印bitmap
     *
     * @param context
     * @return
     */
    public Bitmap getTestPrintBitmap(Context context, PrinterDeviceBean deviceBean) {
        View view = LinearLayout.inflate(context, R.layout.print_test, null);
        TextView tvTime = view.findViewById(R.id.tv_test_print_now_time);
        tvTime.setText("時間：" + TimeUtils.getCurrentDate(TimeUtils.DEFAULT_DATE_FORMAT));
        return viewToZoomBitmap(context, view, deviceBean);
    }


    public Bitmap getBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);
        layout.addView(getTextView(mContext, "炒爐打印測試", Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_10)));
        layout.addView(getTextView(mContext, "時間：" + TimeUtils.getCurrentDate(TimeUtils.DEFAULT_DATE_FORMAT), Gravity.LEFT, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        layout.addView(getTextLine(mContext, "項目"));

        List<PrintFoodItem> printFoodItemList = new ArrayList<>();
        PrintFoodItem productnameBean = new PrintFoodItem();
        productnameBean.setName("測試食品");
        productnameBean.setNum(1);
        productnameBean.setPrice(10.0);

        PrintFoodItem productnameBean2 = new PrintFoodItem();
        productnameBean.setName("測試食品2");
        productnameBean.setNum(2);
        productnameBean.setPrice(30.0);

        printFoodItemList.add(productnameBean);
        printFoodItemList.add(productnameBean2);

        layout.addView(getDiningFoodList(mContext,printFoodItemList, deviceBean, 0, true));
        layout.addView(getTextLine(mContext, "Powered by Gingersoft"));
//        layout.addView(getTextView(mContext, "(USB)", Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));

        return viewToZoomBitmap(mContext, layout, deviceBean);
    }
}
