package com.joe.print.mvp.ui.adapter;

import androidx.annotation.Nullable;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.joe.print.R;
import java.util.List;

/**
 * Created by Wyh on 2020/1/9.
 * 結賬方式
 */
public class BillTypeAdapter extends BaseQuickAdapter<PrintBillItem, BaseViewHolder> {

    public BillTypeAdapter(@Nullable List<PrintBillItem> data) {
        super(R.layout.base_print_item_bill_type, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, PrintBillItem item) {
        helper.setText(R.id.tv_total_amount_text, item.getBillName());
        helper.setText(R.id.tv_total_amount, "$" + item.getBillAmount());
    }
}
