package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.FoodUnitPageModule;
import com.gingersoft.supply_chain.mvp.contract.FoodUnitPageContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.FoodUnitPageFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/28/2020 16:05
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = FoodUnitPageModule.class, dependencies = AppComponent.class)
public interface FoodUnitPageComponent {
    void inject(FoodUnitPageFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        Builder view(FoodUnitPageContract.View view);

        Builder appComponent(AppComponent appComponent);

        FoodUnitPageComponent build();
    }
}