package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.InflowWaterModule;
import com.gingersoft.supply_chain.mvp.contract.InflowWaterContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.InflowWaterFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/08/2021 15:24
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = InflowWaterModule.class, dependencies = AppComponent.class)
public interface InflowWaterComponent {
    void inject(InflowWaterFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        InflowWaterComponent.Builder view(InflowWaterContract.View view);

        InflowWaterComponent.Builder appComponent(AppComponent appComponent);

        InflowWaterComponent build();
    }
}