package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.appcompat.widget.AppCompatTextView;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.CollectionUtils;
import com.gingersoft.gsa.cloud.ui.adapter.BaseSelectorAdapter;
import com.gingersoft.gsa.cloud.ui.view.textview.SuperTextView;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseOrderDetailsBean;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/4/20
 * Time: 12:16
 * Use:
 */
public class SnNameAdapter extends BaseSelectorAdapter<PurchaseOrderDetailsBean.PurchaseOrderDetailsInfoVosBean, BaseViewHolder> {

    public SnNameAdapter(@Nullable List<PurchaseOrderDetailsBean.PurchaseOrderDetailsInfoVosBean> data) {
        super(R.layout.item_base_selector, data);
        if (CollectionUtils.isNotNullOrEmpty(data)) {
            setSelectedIndex(0);
        }
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, PurchaseOrderDetailsBean.PurchaseOrderDetailsInfoVosBean purchaseOrderDetailsInfoVosBean) {
        AppCompatTextView superTextView = viewHolder.getView(R.id.tv_base_select_title);
        AppCompatTextView tvSn = viewHolder.getView(R.id.tv_sn);
        CardView cardView = viewHolder.getView(R.id.card_base_select_layout);
        if (purchaseOrderDetailsInfoVosBean.getFoodMarkSn() == PurchaseFoodBean.HAS_SN) {
            //SN食材
            tvSn.setVisibility(View.VISIBLE);
        } else {
            tvSn.setVisibility(View.GONE);
        }
        superTextView.setText(purchaseOrderDetailsInfoVosBean.getName());
        switch (purchaseOrderDetailsInfoVosBean.getStatus()) {
            case PurchaseOrderDetailsBean.PART_RECEIVED:
                //部分收貨
                cardView.setBackground(ContextCompat.getDrawable(getContext(), R.drawable.shape_orange_twelve_radius));
                tvSn.setTextColor(ContextCompat.getColor(getContext(), R.color.white));
                superTextView.setTextColor(ContextCompat.getColor(getContext(), R.color.white));
                break;
            case PurchaseOrderDetailsBean.COMPLETE_RECEIVED:
                //全部
                cardView.setBackground(ContextCompat.getDrawable(getContext(), R.drawable.shape_red_twelve_radius));
                tvSn.setTextColor(ContextCompat.getColor(getContext(), R.color.white));
                superTextView.setTextColor(ContextCompat.getColor(getContext(), R.color.white));
                break;
            default:
                //默認
                cardView.setBackground(ContextCompat.getDrawable(getContext(), R.drawable.shape_them_border_twelve_white_bg));
                tvSn.setTextColor(ContextCompat.getColor(getContext(), R.color.required_color));
                superTextView.setTextColor(ContextCompat.getColor(getContext(), R.color.color_3c));
                break;
        }
        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams) cardView.getLayoutParams();
        //bottom留3dp。陰影好看些
        if (viewHolder.getAdapterPosition() == 0) {
            //第一個
            //左間距為15
            layoutParams.setMargins(QMUIDisplayHelper.dp2px(getContext(), 15), 0, 0, QMUIDisplayHelper.dp2px(getContext(), 3));
            cardView.setLayoutParams(layoutParams);
        } else if (viewHolder.getAdapterPosition() == getItemCount() - 1) {
            //最後一個
            //左間距為8，右間距為15
            layoutParams.setMargins(QMUIDisplayHelper.dp2px(getContext(), 8), 0, QMUIDisplayHelper.dp2px(getContext(), 15), QMUIDisplayHelper.dp2px(getContext(), 3));
            cardView.setLayoutParams(layoutParams);
        } else {
            //左間距為8，右間距為0
            layoutParams.setMargins(QMUIDisplayHelper.dp2px(getContext(), 8), 0, 0, QMUIDisplayHelper.dp2px(getContext(), 3));
            cardView.setLayoutParams(layoutParams);
        }
    }
}
