package com.gingersoft.supply_chain.mvp.ui.fragment.warehouse;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerSnCodeListComponent;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodEncodeSn;
import com.gingersoft.supply_chain.mvp.bean.WarehouseDetailsBean;
import com.gingersoft.supply_chain.mvp.contract.SnCodeListContract;
import com.gingersoft.supply_chain.mvp.presenter.SnCodeListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.SnCodesAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.widget.QMUITopBar;

import org.w3c.dom.Text;

import java.io.Serializable;
import java.util.List;

import butterknife.BindView;


/**
 * Description: 顯示SN碼列表
 */
public class SnCodeListFragment extends BaseSupplyChainFragment<SnCodeListPresenter> implements SnCodeListContract.View {

    final static String WAREHOUSE_DETAILS_KEY = "warehouseDetailsKey";
    final static String INFO_TYPE_KEY = "infoTypeKey";
    @BindView(R2.id.supply_top_bar)
    QMUITopBar supplyTopBar;
    @BindView(R2.id.tv_remark)
    TextView tvRemark;
    @BindView(R2.id.rv_sn)
    RecyclerView rvSn;
    @BindView(R2.id.tv_sn_housing_num)
    TextView tvHousingNum;

    /**
     * @param infoType             數據類型 0入庫流水SN碼，1出庫流水SN碼
     * @param warehouseDetailsBean 出入庫類
     */
    public static SnCodeListFragment newInstance(int infoType, WarehouseDetailsBean warehouseDetailsBean) {
        SnCodeListFragment fragment = new SnCodeListFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable(WAREHOUSE_DETAILS_KEY, warehouseDetailsBean);
        bundle.putInt(INFO_TYPE_KEY, infoType);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerSnCodeListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_sn_code_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        if (arguments != null) {
            WarehouseDetailsBean warehouseDetailsBean = (WarehouseDetailsBean) arguments.getSerializable(WAREHOUSE_DETAILS_KEY);
            initTopBar(supplyTopBar, warehouseDetailsBean.getName());
            int infoType = arguments.getInt(INFO_TYPE_KEY, 0);
            tvRemark.setText(String.format(getString(R.string.str_format_remark), ""));
            if (infoType == WarehouseDetailsBean.TYPE_WAREHOUSING_TYPE) {
                //查入庫
                mPresenter.querySnCodeList(infoType, warehouseDetailsBean.getWarehousingOrderDetailsIds());
                tvHousingNum.setText(String.valueOf(warehouseDetailsBean.getFoodQuantity()));
            } else if (infoType == WarehouseDetailsBean.TYPE_DELIVERY_HOUSE_TYPE) {
                //查出庫
                mPresenter.querySnCodeList(infoType, warehouseDetailsBean.getPurchaseConsumeNoId());
                if (warehouseDetailsBean.getFoodQuantity() < 0) {
                    tvHousingNum.setText(String.format(getString(R.string.str_format_positive), Math.abs(warehouseDetailsBean.getFoodQuantity()) + ""));
                } else {
                    tvHousingNum.setText(String.format(getString(R.string.str_format_less), warehouseDetailsBean.getFoodQuantity() + ""));
                }
            } else {
                //查剩餘
                mPresenter.queryInStockSnCodes(warehouseDetailsBean.getWarehousingOrderDetailsIds());
                tvHousingNum.setText(String.valueOf(warehouseDetailsBean.getFoodQuantity()));
            }
        } else {
            showMessage("獲取數據失敗");
            killMyself();
        }
    }

    @Override
    public void initAdapter(List<PurchaseFoodEncodeSn> purchaseFoodEncodeSns) {
        SnCodesAdapter adapter = new SnCodesAdapter(purchaseFoodEncodeSns);
        rvSn.setAdapter(adapter);
    }
}
