package com.gingersoft.supply_chain.mvp.ui.widget;

import android.content.Context;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.impl.AttachListPopupView;
import com.lxj.xpopup.interfaces.OnSelectListener;
import com.lxj.xpopup.widget.VerticalRecyclerView;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/29
 * Time: 16:45
 * Use:
 */
public class ChooseUnitPopup extends AttachListPopupView {

    private OnSelectListener selectListener;
    private RecyclerView recyclerView;
    private int width;
    /**
     * @param context
     */
    public ChooseUnitPopup(@NonNull Context context) {
        super(context, 0, R.layout.popup_choose_unit);
    }

    @Override
    protected void onCreate() {
        recyclerView = findViewById(R.id.recyclerView);
        width = popupInfo.atView.getMeasuredWidth();

        recyclerView.setHasFixedSize(false);
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));

        ChooseUnitAdapter adapter = new ChooseUnitAdapter();
        adapter.setOnItemClickListener((a, view, position) -> {
            if (selectListener != null) {
                selectListener.onSelect(position, adapter.getItem(position));
            }
            if (popupInfo.autoDismiss) {
                dismiss();
            }
        });
        recyclerView.setAdapter(adapter);
        applyTheme();
    }

    private List<String> data;

    public ChooseUnitPopup setStringData(List<String> data) {
        this.data = data;
        return this;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        PopupAnimator animator;
        if (isShowUpToTarget()) {
            // 在上方展示
            animator = new ScrollScaleAnimator(getPopupContentView(), PopupAnimation.ScrollAlphaFromBottom);
        } else {
            // 在下方展示
            animator = new ScrollScaleAnimator(getPopupContentView(), PopupAnimation.ScrollAlphaFromTop);
        }
        return animator;
    }
    @Override
    protected void applyDarkTheme() {
        ((VerticalRecyclerView)recyclerView).setupDivider(true);
    }

    @Override
    protected void applyLightTheme() {
        ((VerticalRecyclerView)recyclerView).setupDivider(false);
    }
    @Override
    public ChooseUnitPopup setOnSelectListener(OnSelectListener selectListener) {
        this.selectListener = selectListener;
        return this;
    }

    public class ChooseUnitAdapter extends BaseQuickAdapter<String, BaseViewHolder> {
        public ChooseUnitAdapter() {
            super(R.layout.popup_choose_unit, data);
        }

        @Override
        protected void convert(@NotNull BaseViewHolder viewHolder, String s) {
            viewHolder.setText(R.id.tv_text, s);
            LinearLayout layout = viewHolder.getView(R.id.layout_choose_unit);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(width, LinearLayout.LayoutParams.WRAP_CONTENT);
            layout.setLayoutParams(layoutParams);
        }
    }
}
