//package com.gingersoft.supply_chain.mvp.ui.widget;
//
//import android.content.Context;
//import android.content.res.ColorStateList;
//import android.content.res.TypedArray;
//import android.graphics.Canvas;
//import android.graphics.Paint;
//import android.graphics.Rect;
//import android.graphics.Region;
//import android.graphics.drawable.Drawable;
//import android.text.Layout;
//import android.text.StaticLayout;
//import android.text.TextPaint;
//import android.util.AttributeSet;
//import android.util.Log;
//import android.view.Gravity;
//
//import androidx.annotation.NonNull;
//import androidx.annotation.Nullable;
//import androidx.appcompat.text.AllCapsTransformationMethod;
//import androidx.appcompat.widget.DrawableUtils;
//import androidx.appcompat.widget.SwitchCompat;
//import androidx.appcompat.widget.TintTypedArray;
//import androidx.appcompat.widget.ViewUtils;
//import androidx.core.graphics.drawable.DrawableCompat;
//
//import com.gingersoft.supply_chain.R;
//
//import java.lang.reflect.Field;
//import java.lang.reflect.InvocationTargetException;
//import java.lang.reflect.Method;
//
///**
// * @author 宇航.
// * User: admin
// * Date: 2021/3/19
// * Time: 14:41
// * Use:
// */
//public class TextSwitchCompat extends SwitchCompat {
//
//
//    public TextSwitchCompat(@NonNull Context context) {
//        super(context);
//    }
//
//    public TextSwitchCompat(@NonNull Context context, @Nullable AttributeSet attrs) {
//        super(context, attrs);
//    }
//
//    public TextSwitchCompat(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
//        super(context, attrs, defStyleAttr);
//    }
//
//    private int mThumbTextPadding;
//    private int mSwitchMinWidth;
//    private int mSwitchPadding;
//
//    private Layout mOnLayout;
//    private Layout mOffLayout;
//    private int mSwitchWidth;
//    private int mSwitchHeight;
//
//    private int mThumbWidth;
//
//    private int mSwitchLeft;
//    private int mSwitchTop;
//    private int mSwitchBottom;
//    private int mSwitchRight;
//
//
//    private final Rect padding = new Rect();
//
//    @Override
//    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
//        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
//        if (getShowText()) {
//            if (mOnLayout == null) {
//                mOnLayout = makeLayout(getTextOn());
//            }
//
//            if (mOffLayout == null) {
//                mOffLayout = makeLayout(getTextOff());
//            }
//        }
//        //拿到按鈕
//        Drawable mThumbDrawable = getThumbDrawable();
//        mThumbDrawable.getPadding(padding);
//
//        mThumbWidth = mThumbDrawable.getIntrinsicWidth() - padding.left - padding.right;
//        int thumbHeight = mThumbDrawable.getIntrinsicHeight();
//        //獲取開和關文字最寬的值
//        int maxTextWidth = Math.max(mOnLayout.getWidth(), mOffLayout.getWidth())
//                + getThumbTextPadding() * 2;
//        //拿文字最寬值和按鈕最寬值比較，決定了按鈕的寬度
////        int mThumbWidth = Math.max(maxTextWidth, thumbWidth);
//
//
//        //獲得按鈕的軌道
//        Drawable mTrackDrawable = getTrackDrawable();
//        mTrackDrawable.getPadding(padding);
//        int trackHeight = mTrackDrawable.getIntrinsicHeight();
//
//        int paddingLeft = padding.left;
//        int paddingRight = padding.right;
//        //軌跡的寬度為 按鈕的寬度+文字的寬度
//        final int switchWidth = Math.max(getSwitchMinWidth(),
//                2 * mThumbWidth + paddingLeft + paddingRight + maxTextWidth);
//        final int switchHeight = Math.max(trackHeight, thumbHeight);
//        mSwitchWidth = switchWidth;
//        mSwitchHeight = switchHeight;
////        final int measuredHeight = getMeasuredHeight();
////        if (measuredHeight < switchHeight) {
//        setMeasuredDimension(switchWidth, switchHeight);
////        }
//    }
//
//    private final Rect mTempRect = new Rect();
//
//    @Override
//    protected void onDraw(Canvas canvas) {
////        super.onDraw(canvas);
//        Log.e("eee", "onDraw");
//
//        final Rect padding = mTempRect;
//        final Drawable trackDrawable = getTrackDrawable();
//        if (trackDrawable != null) {
//            trackDrawable.getPadding(padding);
//        } else {
//            padding.setEmpty();
//        }
//
//        final int switchTop = (getPaddingTop() + getHeight() - getPaddingBottom()) / 2 -
//                getHeight() / 2;
//        final int switchBottom = switchTop + getHeight();
//        final int switchInnerTop = switchTop + padding.top;
//        final int switchInnerBottom = switchBottom - padding.bottom;
//
//        final Drawable thumbDrawable = getThumbDrawable();
//        if (trackDrawable != null) {
//            trackDrawable.draw(canvas);
//        }
//
//        final int saveCount = canvas.save();
//        if (thumbDrawable != null) {
//            thumbDrawable.draw(canvas);
//        }
//
//        Class<?> switchCompatClass = getClass().getSuperclass();
//        Method method = null;
//        try {
//            method = switchCompatClass.getDeclaredMethod("getTargetCheckedState");
//        } catch (NoSuchMethodException e) {
//            e.printStackTrace();
//        }
//        method.setAccessible(true);
//        boolean state = false;
//        try {
//            state = (boolean) method.invoke(this);
//        } catch (IllegalAccessException | InvocationTargetException e) {
//            e.printStackTrace();
//        }
//
//        final Layout switchText = state ? mOnLayout : mOffLayout;
//        if (switchText != null) {
//            final int[] drawableState = getDrawableState();
//            ColorStateList textColors = getTextColors();
//            if (textColors != null) {
//                getPaint().setColor(textColors.getColorForState(drawableState, 0));
//            }
//            getPaint().drawableState = drawableState;
//
//            final int cX;
//            final int left;
//            if (thumbDrawable != null) {
//                final Rect bounds = thumbDrawable.getBounds();
//                cX = bounds.left + bounds.right;
//                left = state ? (bounds.left - getLeft() - switchText.getWidth()) / 2 : bounds.right + ((getRight() - bounds.right) - switchText.getWidth()) / 2;
//            } else {
//                cX = getWidth();
//                left = cX / 2 - switchText.getWidth() / 2;
//            }
////            final int left = cX / 2 - switchText.getWidth() / 2;
////            final int top = (switchInnerTop + switchInnerBottom) / 2 - switchText.getHeight() / 2;
//            final int top = (getHeight() - switchText.getHeight()) / 2;
//            canvas.translate(left, top);
//            switchText.draw(canvas);
//        }
//
//        canvas.restoreToCount(saveCount);
//    }
//
//    @Override
//    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
//        super.onLayout(changed, left, top, right, bottom);
//        Log.e("eee", "onLayout");
//
//        int opticalInsetLeft = 0;
//        int opticalInsetRight = 0;
//        Drawable mThumbDrawable = getThumbDrawable();
//        Drawable mTrackDrawable = getTrackDrawable();
//        if (mThumbDrawable != null) {
//            final Rect trackPadding = mTempRect;
//            if (mTrackDrawable != null) {
//                mTrackDrawable.getPadding(trackPadding);
//            } else {
//                trackPadding.setEmpty();
//            }
//
//            opticalInsetLeft = trackPadding.left;
//            opticalInsetRight = trackPadding.right;
//        }
//
//        final int switchLeft = getPaddingLeft() + opticalInsetLeft;
//        final int switchRight = switchLeft + mSwitchWidth - opticalInsetLeft - opticalInsetRight;
//
//        final int switchTop;
//        final int switchBottom;
//        switch (getGravity() & Gravity.VERTICAL_GRAVITY_MASK) {
//            default:
//            case Gravity.TOP:
//                switchTop = getPaddingTop();
//                switchBottom = switchTop + mSwitchHeight;
//                break;
//
//            case Gravity.CENTER_VERTICAL:
//                switchTop = (getPaddingTop() + getHeight() - getPaddingBottom()) / 2 -
//                        mSwitchHeight / 2;
//                switchBottom = switchTop + mSwitchHeight;
//                break;
//
//            case Gravity.BOTTOM:
//                switchBottom = getHeight() - getPaddingBottom();
//                switchTop = switchBottom - mSwitchHeight;
//                break;
//        }
//
//        mSwitchLeft = switchLeft;
//        mSwitchTop = switchTop;
//        mSwitchBottom = switchBottom;
//        mSwitchRight = switchRight;
//    }
//
//    @Override
//    public void draw(Canvas c) {
//        Log.e("eee", "draw");
//        final Rect padding = mTempRect;
//        final int switchLeft = mSwitchLeft;
//        final int switchTop = mSwitchTop;
//        final int switchRight = mSwitchRight;
//        final int switchBottom = mSwitchBottom;
//
//        int thumbInitialLeft = switchLeft;
//        Drawable mThumbDrawable = getThumbDrawable();
//        Drawable mTrackDrawable = getTrackDrawable();
//        final Rect thumbInsets;
//        thumbInsets = DrawableUtils.INSETS_NONE;
//        // Layout the track.
//        if (mTrackDrawable != null) {
//            mTrackDrawable.getPadding(padding);
//
//            // Adjust thumb position for track padding.
//            thumbInitialLeft += padding.left;
//
//            // If necessary, offset by the optical insets of the thumb asset.
//            int trackLeft = switchLeft;
//            int trackTop = switchTop;
//            int trackRight = switchRight;
//            int trackBottom = switchBottom;
//            if (thumbInsets != null) {
//                if (thumbInsets.left > padding.left) {
//                    trackLeft += thumbInsets.left - padding.left;
//                }
//                if (thumbInsets.top > padding.top) {
//                    trackTop += thumbInsets.top - padding.top;
//                }
//                if (thumbInsets.right > padding.right) {
//                    trackRight -= thumbInsets.right - padding.right;
//                }
//                if (thumbInsets.bottom > padding.bottom) {
//                    trackBottom -= thumbInsets.bottom - padding.bottom;
//                }
//            }
//            mTrackDrawable.setBounds(trackLeft, trackTop, trackRight, trackBottom);
//        }
//
//        // Layout the thumb.
//        if (mThumbDrawable != null) {
//            mThumbDrawable.getPadding(padding);
//
//            final int thumbLeft = thumbInitialLeft - padding.left;
//            final int thumbRight = thumbInitialLeft + mThumbWidth + padding.right;
//            mThumbDrawable.setBounds(thumbLeft, switchTop, thumbRight, switchBottom);
//
//            final Drawable background = getBackground();
//            if (background != null) {
//                DrawableCompat.setHotspotBounds(background, thumbLeft, switchTop,
//                        thumbRight, switchBottom);
//            }
//        }
//        super.draw(c);
//    }
//
//    private Layout makeLayout(CharSequence text) {
//        return new StaticLayout(text, getPaint(),
//                text != null ?
//                        (int) Math.ceil(Layout.getDesiredWidth(text, getPaint())) : 0,
//                Layout.Alignment.ALIGN_NORMAL, 1.f, 0, true);
//    }
//
//
//}
