package com.gingersoft.gsa.cloud.table.mvp.action.table;

import android.app.Activity;

import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.table.TableActivity;


/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-23
 * 修订历史：2020-09-23
 * 描述：餐檯模式-轉台{@link TableActivity}
 */
public class MoveTableAction extends TableAction {

    public MoveTableAction(Activity context) {
        super(context, "轉台", "請選擇檯號", "");
    }

    @Override
    public void action(TableBean.DataBean dataBean) {
        if (dataBean.getSplitStatus() == 1) {
            showSplitTableDialogAction();
        } else {
            //獲取餐檯狀態
            moveTable(dataBean);
        }
    }

    @Override
    public boolean filterTableCondition(TableBean.DataBean dataBean) {
        return true;
    }

    @Override
    public void destroy() {

    }
}
