package com.gingersoft.gsa.cloud.table.mvp.contract;

import android.content.Intent;

import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.table.RegionTableFragment;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;

import io.reactivex.Observable;
import io.reactivex.Single;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/09/2020 19:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface MealBillContract {

    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends BaseMealContract.View {

        void initBillAmount(double wholeAmount, double totalAmount);

        void returnTableList(List<TableBean.DataBean> dataBeanList);

        RegionTableFragment getCurrentTableFragment();

        void clickTableItem(TableBean.DataBean dataBean);

        void onStartRefreshTableData();

        void onPauseRefreshTableData();

        void showTransferFoodLayout();

        void hideTransferFoodLayout();

        void showChoosePeopleNumDialog(boolean isNeedCancel);

        void setTopFunctionAdapter(DefaultAdapter adapter);

        void setTopFunctionRecycleLayoutManager();

        void setFoodRecycleSpanCount(int size);

        void printSuccess();

        void startActivityForResult(int Code, Class clazz, Intent intent);

        void sendSuccess();

        void setTransferTableName(String tableName);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends BaseMealContract.Model {

//        List<Discount> queryDB_DiscountList(byte discountScope, byte discountType);

        Single<BaseOrderResponse> createOrder(RequestBody requestBody);

        Single<BaseOrderResponse> addOrderFood(RequestBody requestBody);

        Single<BaseOrderResponse> loadOrder(long orderId);

        Single<BaseOrderResponse> printOrder(RequestBody request);

        Observable<TableBean> getTables(int restaurantId);

        Single<BaseResult> getTable(int tableId, String tableNumber);

        Single<BaseOrderResponse> transferFood(RequestBody requestBody);

        Single<BaseResult> getSplitTables(int tableId);

        Single<BaseResult> queryCoupon(int tableId, Long memberId, long couponMemberId, String couponNo, int restaurantId);
    }
}
