package com.gingersoft.gsa.cloud.table.mvp.contract;


import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;

import io.reactivex.Single;
import okhttp3.RequestBody;

/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/09/2020 19:25
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface MealPayContract {
    interface View extends BaseMealContract.View {

        void recordOperat(boolean isPressButtonSound);

        void showTipDialog(String msg, String btnCancelInfo, String btnOkInfo);

        void paySuccess();

        void loadPayMethodsSuccess(List<PayMethod> payMethods);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends BaseMealContract.Model {

        Single<BaseResult> toOrderPay(RequestBody requestBody);

        Single<BaseResult> getPayMethods(int brandId,int restaurantId,int payType);

        Single<BaseResult> updateOrderPay(RequestBody requestBody);
    }
}
