package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.rxjava.MyRxSchedulerUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealPayContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MealService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.OrderPayService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Single;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/09/2020 19:25
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class MealPayModel extends BaseMealModel implements MealPayContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public MealPayModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Single<BaseResult> getPayMethods(int brandId,int restaurantId,int payType) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .getPayMethods(brandId,restaurantId,payType)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> updateOrderPay( RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .updateOrderPay(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> toOrderPay(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .toOrderPay(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }
}