package com.gingersoft.gsa.cloud.table.mvp.presenter.order;

import android.app.Application;

import com.gingersoft.gsa.cloud.table.mvp.action.order.CancelOrder;
import com.gingersoft.gsa.cloud.table.mvp.action.order.ModifyOrderAction;
import com.gingersoft.gsa.cloud.table.mvp.action.order.PrintOrderAction;
import com.gingersoft.gsa.cloud.table.mvp.action.order.RefundOrder;
import com.gingersoft.gsa.cloud.table.mvp.action.order.TipsOrder;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import javax.inject.Inject;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/13/2020 16:25
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class BaseOrderConterPresenter<M extends IModel,V extends IView> extends BasePresenter{
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    protected M mModel;
    protected V mRootView;

    @Inject
    public BaseOrderConterPresenter(IModel model, IView rootView) {
        super(model, rootView);
        this.mModel = (M) model;
        this.mRootView = (V) rootView;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void printOrder(BaseFragmentActivity activity,OrderManagerResponse orderItem){
       new PrintOrderAction(activity,mRootView)
               .action(orderItem);
    }

    public void modifyOrder(BaseFragmentActivity activity,OrderManagerResponse orderItem){
        new ModifyOrderAction(activity,mRootView)
                .action(orderItem);
    }

    public void orderTips(BaseFragmentActivity activity,OrderManagerResponse orderItem,TipsOrder.OnRefundListener listener){
        TipsOrder tipsOrder = new TipsOrder(activity,mRootView);
        tipsOrder.action(orderItem);
        tipsOrder.setTipsListener(listener);
    }

    public void orderCancel(BaseFragmentActivity activity,OrderManagerResponse orderItem,CancelOrder.OnCancelListener listener){
        CancelOrder cancelOrder = new CancelOrder(activity,mRootView);
        cancelOrder.action(orderItem);
        cancelOrder.setCancelListener(listener);
    }

    public void orderRefund(BaseFragmentActivity activity,OrderManagerResponse orderItem,RefundOrder.OnRefundListener listener){
        RefundOrder refundOrder = new RefundOrder(activity,mRootView);
        refundOrder.action(orderItem);
        refundOrder.setRefundListener(listener);
    }

}
