package com.gingersoft.gsa.cloud.table.mvp.ui.fragment.discount;

import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.gsa.cloud.order.bean.discount.MemberWalletCoupon;
import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.order.order.MealOrder;
import com.gingersoft.gsa.cloud.table.BuildConfig;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.ui.adapter.ViewPager2Adapter;
import com.gingersoft.gsa.cloud.ui.utils.QMUITabSegmentUtils;
import com.jess.arms.base.BaseDialogFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.mvp.BasePresenter;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.tab.QMUITab;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment2;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

/**
 * @作者: bin
 * @創建時間: 2021-04-02 17:14
 * @更新時間: 2021-04-02 17:14
 * @描述:
 */
public class DiscountDialogFragment extends BaseDialogFragment<BasePresenter> {

    private final String TAG = "DiscountFragment";

    @BindView(R2.id.tabSegment)
    QMUITabSegment2 tabSegment;
    @BindView(R2.id.viewPager)
    ViewPager2 contentViewPager;
    @BindView(R2.id.ll_container)
    QMUILinearLayout llContainer;

    private CouponFragment couponFragment;

    private List<String> mTabList = new ArrayList<>();
    private int mCurrentPageIndex = 0;

    public static DiscountDialogFragment newInstance() {
        DiscountDialogFragment fragment = new DiscountDialogFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        this.getDialog().setCanceledOnTouchOutside(false);
        return inflater.inflate(R.layout.table_dialog_discout, container, false);
    }

    @Override
    public void onStart() {
        super.onStart();
        mWindow.setBackgroundDrawable(new ColorDrawable(Color.WHITE));
        WindowManager.LayoutParams lp = mWindow.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = (int) (QMUIDisplayHelper.getScreenHeight(mContext) * 0.6);
        lp.gravity = Gravity.BOTTOM;
        lp.windowAnimations = android.R.style.Animation_InputMethod;
        mWindow.setAttributes(lp);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        float mShadowAlpha = 0.25f;
        int mShadowElevationDp = 14;
        llContainer.setRadiusAndShadow(15, QMUIDisplayHelper.dp2px(mContext, mShadowElevationDp), mShadowAlpha);

        initTabAndPager();
    }

    @Override
    public void setData(@Nullable Object data) {
    }

    private void initTabAndPager() {
        QMUITabBuilder builder = tabSegment.tabBuilder();

        mTabList.add("折扣");
        QMUITab tab1 = builder
                .setText(mTabList.get(0))
                .build(mContext);
        tabSegment.addTab(tab1);

        MemberInfo memberInfo = MealOrder.getInstance().getMemberInfo();
        if (memberInfo != null) {
            mTabList.add("會員錢包");
            QMUITab tab2 = builder
                    .setText(mTabList.get(1))
                    .build(mContext);
            tabSegment.addTab(tab2);
        }
        contentViewPager.setAdapter(new ViewPager2Adapter(this, createFragments()));
        contentViewPager.setCurrentItem(mCurrentPageIndex);
        tabSegment.addOnTabSelectedListener(new QMUITabSegment.OnTabSelectedListener() {

            @Override
            public void onTabSelected(int index) {
                LoganManager.w_tableMode(TAG, "當前頁面【" + mTabList.get(index) + "】");
            }

            @Override
            public void onTabUnselected(int index) {
            }

            @Override
            public void onTabReselected(int index) {
            }

            @Override
            public void onDoubleTap(int index) {
            }
        });
        QMUITabSegmentUtils.setNomalTabSegmentStyle(tabSegment, contentViewPager);
    }

    private List<Fragment> createFragments() {
        List<Fragment> fragments = new ArrayList<>();

        NomalDiscountFragment billDiscountFragment = NomalDiscountFragment.newInstance();
        billDiscountFragment.setOnDiscountItemClickListener(new NomalDiscountFragment.OnBillDiscountItemClickListener() {
            @Override
            public void onItemClick(Discount item, int position) {
                if (onDiscountItemClickListener != null) {
                    onDiscountItemClickListener.onBillDiscountClick(item, position);
                }
            }
        });
        fragments.add(billDiscountFragment);
        if (BuildConfig.DEBUG) {
            MemberInfo memberInfo = MealOrder.getInstance().getMemberInfo();
            if (memberInfo != null) {
                couponFragment = CouponFragment.newInstance(CouponFragment.BILL_LIMIT_DISCOUNT);
                couponFragment.setOnCouponItemClickListener(new CouponFragment.OnCouponItemClickListener() {
                    @Override
                    public void onItemClick(MemberWalletCoupon item, int position) {
                        if (onDiscountItemClickListener != null) {
                            onDiscountItemClickListener.onCouponClick(item, position);
                        }
                    }
                });
                fragments.add(couponFragment);
            }
        }
        return fragments;
    }

    private OnDiscountItemClickListener onDiscountItemClickListener;

    public void setOnDiscountItemClickListener(OnDiscountItemClickListener onDiscountItemClickListener) {
        this.onDiscountItemClickListener = onDiscountItemClickListener;
    }

    public interface OnDiscountItemClickListener {
        void onBillDiscountClick(Discount item, int position);

        void onCouponClick(MemberWalletCoupon item, int position);
    }
}
