package com.gingersoft.gsa.cloud.common.config.globalconfig.lifecyclesOptioins;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

import com.gingersoft.gsa.cloud.common.logan.LoganManager;


@SuppressLint("NewApi")
public class MyFragmentLifecycle extends FragmentManager.FragmentLifecycleCallbacks {

    private static final String TAG = MyFragmentLifecycle.class.getSimpleName();

    @Override
    public void onFragmentAttached(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Context context) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentAttached");
    }

    @Override
    public void onFragmentCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentCreated");
    }

    @Override
    public void onFragmentActivityCreated(@NonNull FragmentManager fm, @NonNull Fragment f,
                                          @Nullable Bundle savedInstanceState) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentActivityCreated");
    }

    @Override
    public void onFragmentViewCreated(@NonNull FragmentManager fm, @NonNull Fragment f,
                                      @NonNull View v, @Nullable Bundle savedInstanceState) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentViewCreated");
    }

    @Override
    public void onFragmentStarted(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentStarted");
    }

    @Override
    public void onFragmentResumed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentResumed");
    }

    @Override
    public void onFragmentPaused(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentPaused");
    }

    @Override
    public void onFragmentStopped(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentStopped");
    }

    @Override
    public void onFragmentSaveInstanceState(@NonNull FragmentManager fm, @NonNull Fragment f,
                                            @NonNull Bundle outState) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentSaveInstanceState");
    }

    @Override
    public void onFragmentViewDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentViewDestroyed");
    }

    @Override
    public void onFragmentDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentDestroyed");
    }

    @Override
    public void onFragmentDetached(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganManager.w_action(TAG, f.getClass().getSimpleName()  + ": onFragmentDetached");
    }
}
