package com.gingersoft.gsa.cloud.common.constans;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.common.BuildConfig;
import com.gingersoft.gsa.cloud.common.utils.other.SPUtils;

/**
 * Created by Wyh on 2019/12/21.
 */
public class HttpsConstans {

//    public static String ROOT_ADDRESS_FORMAL = "https://m.ricepon.com:8444/ricepon-cloud-gsa/api/";//正式服務器
//    public static final String ROOT_SERVER_ADDRESS_FORMAL_SZ = "http://gingersoft.tpddns.cn:58201/ricepon-cloud-gsa/api/";//深圳服务器
//    public static final String ROOT_SERVER_ADDRESS_FORMAL_HK = "http://a.ricepon.com:58201/ricepon-cloud-gsa/api/";//香港服务器
//    public static String ROOT_SERVER_YOU_CHANG_HK = "http://192.168.1.142:9012/api/"; //友常本地
//    public static String ROOT_SERVER_SHI_WEI_HK = "http://192.168.1.154:9012/api/"; //世維本地
//    //默認為正式
//    public static String ROOT_SERVER_ADDRESS_FORMAL = ROOT_SERVER_ADDRESS_FORMAL_HK;
//
//    //外賣接單
//    public static final String ROOT_SZ_URL = "http://192.168.1.74:6060";//友常本地
//    public static final String ROOT_HK_TEST_URL = "https://hktest.ricepon.com:64377";//香港測試
//    public static final String ROOT_FORMAL_URL = "https://m.ricepon.com";//正式
//    public static String ROOT_URL = HttpsConstans.ROOT_HK_TEST_URL;
//
//    //清機接口地址
//    public static String ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = "http://a.ricepon.com:58201/";
//    //報表地址
//    public static String REPORT_SERVER_ADDRESS = "http://a.ricepon.com:58201/ricepon-report/api/";
//    //微信公眾號報表地址：首頁曲線圖數據，支付分析報表數據
//    public static String WECHAR_REPORT_SERVER_ADDRESS = "http://a.ricepon.com:61177/member-web/api/";
//    //報表地址
//    public static String _SERVER_ADDRESS = "http://a.ricepon.com:61177/member-web/api/";

    //--------------------------------------------其他全局----------------------------------------------------------------------------
    private static String HTTP_ADDRESS_URL_FORMAL = "https://m.ricepon.com:8444";//正式服務器
    private static String HTTP_ADDRESS_URL_SZ = "http://gingersoft.tpddns.cn:58201";//深圳測試
    public static String HTTP_ADDRESS_URL_HK = "http://a.ricepon.com:58201";//香港測試 https://hktest.ricepon.com
    private static String HTTP_ADDRESS_URL_PRE = "http://prf-m.ricepon.com";//預發佈

    public static String CLOUD_GSA_API_PATH = "/ricepon-cloud-gsa/api/";//雲端GSA路徑
    public static String RESTAURANT_API_PATH = "/ricepon-restaurant/api/";//餐廳模塊路徑
    public static String PURCHASE_API_PATH = "/ricepon-purchase/api/";//供應鏈路徑

//    public static String ROOT_SERVER_YOU_CHANG_HK = "http://192.168.1.149:9015/api"; //友常本地
    public static String ROOT_SERVER_YOU_CHANG_HK = "http://192.168.1.161:9016/api"; //溫浩本地
    public static String ROOT_SERVER_ZHI_WANG_HK = "http://192.168.1.169:9012/api"; //世維本地
    public static String ROOT_SERVER_SHI_SHU_HK = "http://192.168.1.154:9012/api"; //石书本地

    //------------------------------------------外賣接單---------------------------------------------------------------------------
    public static final String URL_RICEPON_WECHAT = "/ricepon-wechat/api/";
    public static final String URL_RICEPON_ORDER = "/ricepon-order/api/";
    public static final String URK_RICEPON_GSA = "/ricepon-gsa/api/";
    public static final String URK_RICEPON_ACTIVITIES = "/ricepon-activities/api/";


    public static final String URL_MEMBER_WEB_RICEPON_GSA = "/member-web" + URK_RICEPON_GSA;

    public static final String ROOT_SZ_URL = "http://192.168.1.74:6060";//友常本地
    public static final String ROOT_HK_TEST_URL = "https://hktest.ricepon.com:64377";//香港測試
    public static final String ROOT_FORMAL_URL = "https://m.ricepon.com";//正式

    //-------------------------------------------報表-------------------------------------------------------------------------------
    public static String REPORT_TEST_ADDRESS = "http://a.ricepon.com:58201";//報表測試地址

    public static String REPORT_FORMAL_ADDRESS = HTTP_ADDRESS_URL_FORMAL;//報表正式地址
    //報表路徑
    public static String REPORT_PATH = "/ricepon-report/api/";

    //----------------------------------微信公眾號報表地址------------------------------------------------------------------------------------------
    public static String WECHAR_REPORT_TEST_ADDRESS = "http://a.ricepon.com:61177";//微信公眾號報表測試地址
    public static String WECHAR_REPORT_FORMAL_ADDRESS = HTTP_ADDRESS_URL_FORMAL;//微信公眾號報表正式地址
    public static String WECHAR_REPORT_PATH = "/member-web/api/";//微信公眾號報表路徑

    //---------------------------------------System請求地址----------------------------------------------------------------------------------
    public static String SYSTEM_PATH = "/ricepon-system/api/";
    public static String API_RICEPON_MEMBER = "/ricepon-member/api/";

    //-------------------------------------------支付-------------------------------------------------------------------------------
    public static String PAY_PATH = "/ricepon-pay/api/";

    /**
     * QRCode相關
     */
    public static final String PRINT_QRCODE_ADDRESS_URL_FORMAL = "http://m.ricepon.com";
    public static final String PRINT_QRCODE_ADDRESS_URL_HK = "http://hktest.ricepon.com:61177";

    //---------------------------------------打印Skyorder QRCode----------------------------------------------------------------------------------
    public static final String PRINT_SKY_QRCODE_SUFFIX = "/member-web/qrcode/qrcode.html?WMP0&?arg=";
    public static String PRINT_SKY_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_FORMAL + PRINT_SKY_QRCODE_SUFFIX;

    //----------------------------------------打印積分QRCode-----------------------------------------------------------------------------------------
    public static final String PRINT_QRCODE_SUFFIX = "/member-web/qrcode/qrcode.html?arg=";
    public static String PRINT_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_FORMAL + PRINT_QRCODE_SUFFIX;


    //--------------------------------------配置-----------------------------------------------------------------------------------

    /**
     * 修改這個值控制是否是正式
     * 0=正式
     * 1=香港
     * 2=預發佈
     * 3=友常
     * 4=石书
     */
    public static int isFormal = 0;

    //沽清控制地址
    public static String _SERVER_ADDRESS;// = (isFormal ? HTTP_ADDRESS_URL_FORMAL : "http://a.ricepon.com:61177") + "/member-web/api/";

    //清機接口地址
    public static String ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL;// = isFormal ? HTTP_ADDRESS_URL_FORMAL : REPORT_TEST_ADDRESS;

    //默認url，配置這個值修改環境
    public static String ROOT_SERVER_ADDRESS_FORMAL = HTTP_ADDRESS_URL_FORMAL + CLOUD_GSA_API_PATH;

    public static String ROOT_SERVER_ADDRESS_FORMAL_RESTAURANT = HTTP_ADDRESS_URL_FORMAL + RESTAURANT_API_PATH;

    public static String ROOT_SERVER_ADDRESS_RICEPON_PURCHASE = HTTP_ADDRESS_URL_FORMAL + PURCHASE_API_PATH;

    public static String ROOT_SERVER = HTTP_ADDRESS_URL_FORMAL;

    //修改這個值，配置外賣接單環境
    public static String ROOT_URL;// = isFormal ? ROOT_FORMAL_URL : ROOT_HK_TEST_URL;//正式：ROOT_FORMAL_URL   測試：ROOT_HK_TEST_URL

    //修改這個值，修改報表默認環境
    public static String REPORT_SERVER_ADDRESS;// = (isFormal ? REPORT_FORMAL_ADDRESS : REPORT_TEST_ADDRESS) + REPORT_PATH;//測試：REPORT_FORMAL_ADDRESS 正式：REPORT_TEST_ADDRESS

    //修改這個值，修改微信公眾號報表地址：首頁曲線圖數據，支付分析報表數據
    public static String WECHAR_REPORT_SERVER_ADDRESS;// = (isFormal ? WECHAR_REPORT_FORMAL_ADDRESS : WECHAR_REPORT_TEST_ADDRESS) + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS

    public static String SYSTEM_URL;

    public static String RICEPON_MEMBER_SERVER_ADDRESS;

    public static String RICEPON_MEMBER_61177;

    public static final String UPLOAD_PIC_ADDRESS = "/ricepon-member/api/admin/member/fileUploadBase64";
    public static String UPLOAD_PIC_URL;

    public static String HK_TEST_RICEPON_MEMBER;

    public static void init(Context context) {
        isFormal = (int) SPUtils.get("isFormal", -1);
        if (isFormal == -1 && BuildConfig.DEBUG) {
            //如果沒有手動配置過服務器，並且是DEBUG模式，默認是測試服務器
            isFormal = 1;
        } else if (isFormal == -1) {
            isFormal = 0;
        }
        switch (isFormal) {
            default:
                RICEPON_MEMBER_61177 = HTTP_ADDRESS_URL_FORMAL + API_RICEPON_MEMBER;
                _SERVER_ADDRESS = HTTP_ADDRESS_URL_FORMAL + WECHAR_REPORT_PATH;
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = HTTP_ADDRESS_URL_FORMAL;
                ROOT_SERVER_ADDRESS_FORMAL = HTTP_ADDRESS_URL_FORMAL + CLOUD_GSA_API_PATH;
                ROOT_SERVER_ADDRESS_FORMAL_RESTAURANT = HTTP_ADDRESS_URL_FORMAL + RESTAURANT_API_PATH;
                ROOT_SERVER_ADDRESS_RICEPON_PURCHASE = HTTP_ADDRESS_URL_FORMAL + PURCHASE_API_PATH;
                ROOT_URL = ROOT_FORMAL_URL;
                REPORT_SERVER_ADDRESS = REPORT_FORMAL_ADDRESS + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = WECHAR_REPORT_FORMAL_ADDRESS + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS
                RICEPON_MEMBER_SERVER_ADDRESS = WECHAR_REPORT_FORMAL_ADDRESS + WECHAR_REPORT_PATH;
                SYSTEM_URL = HTTP_ADDRESS_URL_FORMAL + SYSTEM_PATH;
                ROOT_SERVER = HTTP_ADDRESS_URL_FORMAL;
                PRINT_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_FORMAL + PRINT_QRCODE_SUFFIX;
                UPLOAD_PIC_URL = HTTP_ADDRESS_URL_FORMAL + UPLOAD_PIC_ADDRESS;
                HK_TEST_RICEPON_MEMBER = HTTP_ADDRESS_URL_FORMAL + API_RICEPON_MEMBER;
                break;
            case 1:
                RICEPON_MEMBER_61177 = WECHAR_REPORT_TEST_ADDRESS + API_RICEPON_MEMBER;
                _SERVER_ADDRESS = WECHAR_REPORT_TEST_ADDRESS + WECHAR_REPORT_PATH;
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = REPORT_TEST_ADDRESS;
                ROOT_SERVER_ADDRESS_FORMAL = HTTP_ADDRESS_URL_HK + CLOUD_GSA_API_PATH;
                ROOT_SERVER_ADDRESS_FORMAL_RESTAURANT = HTTP_ADDRESS_URL_HK + RESTAURANT_API_PATH;
                ROOT_SERVER_ADDRESS_RICEPON_PURCHASE = HTTP_ADDRESS_URL_HK + PURCHASE_API_PATH;
                ROOT_URL = ROOT_HK_TEST_URL;
                REPORT_SERVER_ADDRESS = REPORT_TEST_ADDRESS + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = WECHAR_REPORT_TEST_ADDRESS + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS
                SYSTEM_URL = ROOT_HK_TEST_URL + SYSTEM_PATH;
                ROOT_SERVER = HTTP_ADDRESS_URL_HK;
                PRINT_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_HK + PRINT_QRCODE_SUFFIX;
                UPLOAD_PIC_URL = ROOT_HK_TEST_URL + UPLOAD_PIC_ADDRESS;
                HK_TEST_RICEPON_MEMBER = ROOT_HK_TEST_URL + API_RICEPON_MEMBER;
                break;
            case 2:
                //預發佈
                RICEPON_MEMBER_61177 = HTTP_ADDRESS_URL_PRE + API_RICEPON_MEMBER;
                _SERVER_ADDRESS = HTTP_ADDRESS_URL_PRE + WECHAR_REPORT_PATH;
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = HTTP_ADDRESS_URL_PRE;
                ROOT_SERVER_ADDRESS_FORMAL = HTTP_ADDRESS_URL_PRE + CLOUD_GSA_API_PATH;
                ROOT_SERVER_ADDRESS_FORMAL_RESTAURANT = HTTP_ADDRESS_URL_PRE + RESTAURANT_API_PATH;
                ROOT_SERVER_ADDRESS_RICEPON_PURCHASE = HTTP_ADDRESS_URL_PRE + PURCHASE_API_PATH;
                ROOT_URL = HTTP_ADDRESS_URL_PRE;
                REPORT_SERVER_ADDRESS = HTTP_ADDRESS_URL_PRE + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = HTTP_ADDRESS_URL_PRE + WECHAR_REPORT_PATH;
                SYSTEM_URL = HTTP_ADDRESS_URL_PRE + SYSTEM_PATH;
                ROOT_SERVER = HTTP_ADDRESS_URL_PRE;
                PRINT_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_FORMAL + PRINT_QRCODE_SUFFIX;
                UPLOAD_PIC_URL = HTTP_ADDRESS_URL_PRE + UPLOAD_PIC_ADDRESS;
                HK_TEST_RICEPON_MEMBER = HTTP_ADDRESS_URL_PRE + API_RICEPON_MEMBER;
                break;
            case 3:
                RICEPON_MEMBER_61177 = WECHAR_REPORT_TEST_ADDRESS + API_RICEPON_MEMBER;
                _SERVER_ADDRESS = ROOT_SERVER_ZHI_WANG_HK + WECHAR_REPORT_PATH;
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = REPORT_TEST_ADDRESS;
                ROOT_SERVER_ADDRESS_FORMAL = ROOT_SERVER_ZHI_WANG_HK;
                ROOT_SERVER_ADDRESS_FORMAL_RESTAURANT = ROOT_SERVER_YOU_CHANG_HK + RESTAURANT_API_PATH;
                ROOT_SERVER_ADDRESS_RICEPON_PURCHASE = ROOT_SERVER_YOU_CHANG_HK;// + PURCHASE_API_PATH
                ROOT_URL = ROOT_SZ_URL;
                REPORT_SERVER_ADDRESS = REPORT_TEST_ADDRESS + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = WECHAR_REPORT_TEST_ADDRESS + WECHAR_REPORT_PATH;
                SYSTEM_URL = ROOT_SERVER_ZHI_WANG_HK + SYSTEM_PATH;
                ROOT_SERVER = ROOT_SERVER_YOU_CHANG_HK;
                PRINT_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_HK + PRINT_QRCODE_SUFFIX;
                UPLOAD_PIC_URL = ROOT_SERVER_YOU_CHANG_HK + UPLOAD_PIC_ADDRESS;
                HK_TEST_RICEPON_MEMBER = ROOT_SERVER_YOU_CHANG_HK + API_RICEPON_MEMBER;
                break;
            case 4:
                RICEPON_MEMBER_61177 = WECHAR_REPORT_TEST_ADDRESS + API_RICEPON_MEMBER;
                _SERVER_ADDRESS = ROOT_SERVER_YOU_CHANG_HK + WECHAR_REPORT_PATH;
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = REPORT_TEST_ADDRESS;
                ROOT_SERVER_ADDRESS_FORMAL = ROOT_SERVER_YOU_CHANG_HK;
                ROOT_URL = ROOT_SZ_URL;
                REPORT_SERVER_ADDRESS = REPORT_TEST_ADDRESS + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = WECHAR_REPORT_TEST_ADDRESS + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS
                SYSTEM_URL = ROOT_SERVER_YOU_CHANG_HK + SYSTEM_PATH;
                PRINT_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_HK + PRINT_QRCODE_SUFFIX;
                break;
            case 5:
                RICEPON_MEMBER_61177 = WECHAR_REPORT_TEST_ADDRESS + API_RICEPON_MEMBER;
                _SERVER_ADDRESS = ROOT_SERVER_SHI_SHU_HK + WECHAR_REPORT_PATH;
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = REPORT_TEST_ADDRESS;
                ROOT_SERVER_ADDRESS_FORMAL = ROOT_SERVER_SHI_SHU_HK;
                ROOT_URL = ROOT_SZ_URL;
                REPORT_SERVER_ADDRESS = REPORT_TEST_ADDRESS + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = WECHAR_REPORT_TEST_ADDRESS + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS
                SYSTEM_URL = ROOT_SERVER_SHI_SHU_HK + SYSTEM_PATH;
                PRINT_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_HK + PRINT_QRCODE_SUFFIX;
                break;
        }
        ricepon_pay = HttpsConstans.ROOT_URL + HttpsConstans.PAY_PATH;
        ricepon_wechat = HttpsConstans.ROOT_URL + HttpsConstans.URL_RICEPON_WECHAT;
        ricepon_order = HttpsConstans.ROOT_URL + HttpsConstans.URL_RICEPON_ORDER;
        member_web_ricepon_gsa = HttpsConstans.ROOT_URL + HttpsConstans.URL_MEMBER_WEB_RICEPON_GSA;
        member_web = HttpsConstans.ROOT_URL + HttpsConstans.WECHAR_REPORT_PATH;
        ricepon_gsa = HttpsConstans.ROOT_URL + HttpsConstans.URK_RICEPON_GSA;
        ricepon_activities = HttpsConstans.ROOT_URL + HttpsConstans.URK_RICEPON_ACTIVITIES;
        ricepon_cloud_gsa = HttpsConstans.ROOT_URL + HttpsConstans.CLOUD_GSA_API_PATH;
        ricepon_member = HttpsConstans.ROOT_URL + API_RICEPON_MEMBER;

//        PRINT_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_FORMAL + PRINT_QRCODE_SUFFIX;
    }

    public static String ricepon_pay;
    public static String ricepon_wechat;
    public static String ricepon_order;
    public static String member_web_ricepon_gsa;
    public static String member_web;
    public static String ricepon_gsa;
    public static String ricepon_activities;
    public static String ricepon_cloud_gsa;
    public static String ricepon_member;


}