package com.gingersoft.gsa.cloud.common.function;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:標識單個功能是否顯示，如：
 *
 *   @XFunctionView()
 *   @BindView(R2.id.btn_send_order)
 *   Button btn_send_order;
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface XFunctionView {

    String  value();

    //viewId
    int viewId();
}
