package com.gingersoft.gsa.cloud.common.oaId.defaultImp;

import android.text.TextUtils;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.jess.arms.utils.DataHelper;

/**
 * @作者: bin
 * @創建時間: 2020-12-25 15:01
 * @更新時間: 2020-12-25 15:01
 * @描述: 方案3：ush + "_" + UUID + SharePreference(存取)
 */
public class SPDeviceId {

    /**
     * 方案3：UUID + SharePreference(存取)
     * APP首次使用时，创建UUID，并保存到SharePreference中。
     * 以后再次使用时，直接从SharePreference取出来即可；
     * <p>
     * 优点：数据唯一、不需要权限；
     * 缺点：会随APP一起删除，即：重新安装APP，DeviceId值会改变（新UUID）；
     */
    private static final String scheme_3 = "ush";


    public static String getSPDeviceId(String defaultDeviceId) {
        String deviceId = DataHelper.getStringSF(GsaCloudApplication.getAppContext(), scheme_3);
        if (TextUtils.isEmpty(deviceId)) {
            defaultDeviceId = scheme_3 + "_" + defaultDeviceId;
            //SP數據丟失 重新使用最新的UUID作為deviceId
            putSPDeviceId(defaultDeviceId);
            deviceId = defaultDeviceId;
        }
        return deviceId;
    }

    public static void putSPDeviceId(String defaultDeviceId) {
        DataHelper.setStringSF(GsaCloudApplication.getAppContext(), scheme_3, defaultDeviceId);
    }
}
