package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.ColorBean;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "COLOR_BEAN".
*/
public class ColorBeanDao extends AbstractDao<ColorBean, Long> {

    public static final String TABLENAME = "COLOR_BEAN";

    /**
     * Properties of entity ColorBean.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property ColorId = new Property(0, Long.class, "colorId", true, "_id");
        public final static Property ColorStart = new Property(1, String.class, "colorStart", false, "COLOR_START");
        public final static Property ColorStop = new Property(2, String.class, "colorStop", false, "COLOR_STOP");
        public final static Property FontColor = new Property(3, String.class, "fontColor", false, "FONT_COLOR");
        public final static Property AndroidColor = new Property(4, String.class, "androidColor", false, "ANDROID_COLOR");
        public final static Property AndroidFontColor = new Property(5, String.class, "androidFontColor", false, "ANDROID_FONT_COLOR");
        public final static Property CreateTime = new Property(6, String.class, "createTime", false, "CREATE_TIME");
        public final static Property EditTime = new Property(7, String.class, "editTime", false, "EDIT_TIME");
    }


    public ColorBeanDao(DaoConfig config) {
        super(config);
    }
    
    public ColorBeanDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"COLOR_BEAN\" (" + //
                "\"_id\" INTEGER PRIMARY KEY ," + // 0: colorId
                "\"COLOR_START\" TEXT," + // 1: colorStart
                "\"COLOR_STOP\" TEXT," + // 2: colorStop
                "\"FONT_COLOR\" TEXT," + // 3: fontColor
                "\"ANDROID_COLOR\" TEXT," + // 4: androidColor
                "\"ANDROID_FONT_COLOR\" TEXT," + // 5: androidFontColor
                "\"CREATE_TIME\" TEXT," + // 6: createTime
                "\"EDIT_TIME\" TEXT);"); // 7: editTime
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"COLOR_BEAN\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, ColorBean entity) {
        stmt.clearBindings();
 
        Long colorId = entity.getColorId();
        if (colorId != null) {
            stmt.bindLong(1, colorId);
        }
 
        String colorStart = entity.getColorStart();
        if (colorStart != null) {
            stmt.bindString(2, colorStart);
        }
 
        String colorStop = entity.getColorStop();
        if (colorStop != null) {
            stmt.bindString(3, colorStop);
        }
 
        String fontColor = entity.getFontColor();
        if (fontColor != null) {
            stmt.bindString(4, fontColor);
        }
 
        String androidColor = entity.getAndroidColor();
        if (androidColor != null) {
            stmt.bindString(5, androidColor);
        }
 
        String androidFontColor = entity.getAndroidFontColor();
        if (androidFontColor != null) {
            stmt.bindString(6, androidFontColor);
        }
 
        String createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindString(7, createTime);
        }
 
        String editTime = entity.getEditTime();
        if (editTime != null) {
            stmt.bindString(8, editTime);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, ColorBean entity) {
        stmt.clearBindings();
 
        Long colorId = entity.getColorId();
        if (colorId != null) {
            stmt.bindLong(1, colorId);
        }
 
        String colorStart = entity.getColorStart();
        if (colorStart != null) {
            stmt.bindString(2, colorStart);
        }
 
        String colorStop = entity.getColorStop();
        if (colorStop != null) {
            stmt.bindString(3, colorStop);
        }
 
        String fontColor = entity.getFontColor();
        if (fontColor != null) {
            stmt.bindString(4, fontColor);
        }
 
        String androidColor = entity.getAndroidColor();
        if (androidColor != null) {
            stmt.bindString(5, androidColor);
        }
 
        String androidFontColor = entity.getAndroidFontColor();
        if (androidFontColor != null) {
            stmt.bindString(6, androidFontColor);
        }
 
        String createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindString(7, createTime);
        }
 
        String editTime = entity.getEditTime();
        if (editTime != null) {
            stmt.bindString(8, editTime);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public ColorBean readEntity(Cursor cursor, int offset) {
        ColorBean entity = new ColorBean( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // colorId
            cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), // colorStart
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // colorStop
            cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), // fontColor
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // androidColor
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // androidFontColor
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // createTime
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7) // editTime
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, ColorBean entity, int offset) {
        entity.setColorId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setColorStart(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setColorStop(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setFontColor(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setAndroidColor(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setAndroidFontColor(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setCreateTime(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setEditTime(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(ColorBean entity, long rowId) {
        entity.setColorId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(ColorBean entity) {
        if(entity != null) {
            return entity.getColorId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(ColorBean entity) {
        return entity.getColorId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
