package com.gingersoft.gsa.cloud.database.greendao;

import java.util.List;
import java.util.ArrayList;
import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.SqlUtils;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.ColorBean;

import com.gingersoft.gsa.cloud.database.bean.Food;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "FOOD".
*/
public class FoodDao extends AbstractDao<Food, Long> {

    public static final String TABLENAME = "FOOD";

    /**
     * Properties of entity Food.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "FID");
        public final static Property ParentId = new Property(1, long.class, "parentId", false, "PARENT_ID");
        public final static Property RestaurantId = new Property(2, long.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property IsParent = new Property(3, byte.class, "isParent", false, "IS_PARENT");
        public final static Property SeqNo = new Property(4, long.class, "seqNo", false, "SEQ_NO");
        public final static Property FoodName = new Property(5, String.class, "foodName", false, "FOOD_NAME");
        public final static Property FoodName1 = new Property(6, String.class, "foodName1", false, "FOOD_NAME1");
        public final static Property FoodName2 = new Property(7, String.class, "foodName2", false, "FOOD_NAME2");
        public final static Property Plu = new Property(8, String.class, "plu", false, "PLU");
        public final static Property CustomType = new Property(9, Integer.class, "customType", false, "CUSTOM_TYPE");
        public final static Property PosFid = new Property(10, String.class, "posFid", false, "POS_FID");
        public final static Property FoodDesc = new Property(11, String.class, "foodDesc", false, "FOOD_DESC");
        public final static Property LimitAmount = new Property(12, long.class, "limitAmount", false, "LIMIT_AMOUNT");
        public final static Property LimitType = new Property(13, long.class, "limitType", false, "LIMIT_TYPE");
        public final static Property FoodSummary = new Property(14, String.class, "foodSummary", false, "FOOD_SUMMARY");
        public final static Property Invisible = new Property(15, long.class, "invisible", false, "INVISIBLE");
        public final static Property AutoMod = new Property(16, byte.class, "autoMod", false, "AUTO_MOD");
        public final static Property Price = new Property(17, double.class, "price", false, "PRICE");
        public final static Property MarketPrice = new Property(18, double.class, "marketPrice", false, "MARKET_PRICE");
        public final static Property LunchboxPrice = new Property(19, double.class, "lunchboxPrice", false, "LUNCHBOX_PRICE");
        public final static Property ImgUrlSmall = new Property(20, String.class, "imgUrlSmall", false, "IMG_URL_SMALL");
        public final static Property Imageurl = new Property(21, String.class, "imageurl", false, "IMAGEURL");
        public final static Property RiceponInvisible = new Property(22, long.class, "riceponInvisible", false, "RICEPON_INVISIBLE");
        public final static Property Cost = new Property(23, double.class, "cost", false, "COST");
        public final static Property Like = new Property(24, long.class, "like", false, "LIKE");
        public final static Property TotalSold = new Property(25, long.class, "totalSold", false, "TOTAL_SOLD");
        public final static Property IsSold = new Property(26, long.class, "isSold", false, "IS_SOLD");
        public final static Property StartDate = new Property(27, java.util.Date.class, "startDate", false, "START_DATE");
        public final static Property EndDate = new Property(28, java.util.Date.class, "endDate", false, "END_DATE");
        public final static Property CreateBy = new Property(29, String.class, "createBy", false, "CREATE_BY");
        public final static Property CreateTime = new Property(30, java.util.Date.class, "createTime", false, "CREATE_TIME");
        public final static Property UpdateBy = new Property(31, String.class, "updateBy", false, "UPDATE_BY");
        public final static Property UpdateTime = new Property(32, java.util.Date.class, "updateTime", false, "UPDATE_TIME");
        public final static Property PeriodId = new Property(33, long.class, "periodId", false, "PERIOD_ID");
        public final static Property AbleDiscount = new Property(34, long.class, "ableDiscount", false, "ABLE_DISCOUNT");
        public final static Property Takeaway = new Property(35, long.class, "takeaway", false, "TAKEAWAY");
        public final static Property BlueEdit = new Property(36, long.class, "blueEdit", false, "BLUE_EDIT");
        public final static Property CartEdit = new Property(37, long.class, "cartEdit", false, "CART_EDIT");
        public final static Property AutoMerge = new Property(38, long.class, "autoMerge", false, "AUTO_MERGE");
        public final static Property PrintSeting = new Property(39, String.class, "printSeting", false, "PRINT_SETING");
        public final static Property IsPrintQueueCode = new Property(40, long.class, "isPrintQueueCode", false, "IS_PRINT_QUEUE_CODE");
        public final static Property QueueHeadId = new Property(41, long.class, "queueHeadId", false, "QUEUE_HEAD_ID");
        public final static Property Approve = new Property(42, long.class, "approve", false, "APPROVE");
        public final static Property PrintFont = new Property(43, long.class, "printFont", false, "PRINT_FONT");
        public final static Property AdvPrice = new Property(44, long.class, "advPrice", false, "ADV_PRICE");
        public final static Property PrintToBill = new Property(45, long.class, "printToBill", false, "PRINT_TO_BILL");
        public final static Property PointsAdd = new Property(46, double.class, "pointsAdd", false, "POINTS_ADD");
        public final static Property PointsRatio = new Property(47, long.class, "pointsRatio", false, "POINTS_RATIO");
        public final static Property PointsRedeem = new Property(48, double.class, "pointsRedeem", false, "POINTS_REDEEM");
        public final static Property KtPrintMainItem = new Property(49, long.class, "ktPrintMainItem", false, "KT_PRINT_MAIN_ITEM");
        public final static Property KtShowPrice = new Property(50, long.class, "ktShowPrice", false, "KT_SHOW_PRICE");
        public final static Property PrintTo = new Property(51, long.class, "printTo", false, "PRINT_TO");
        public final static Property ToPax = new Property(52, long.class, "toPax", false, "TO_PAX");
        public final static Property FoodType = new Property(53, long.class, "foodType", false, "FOOD_TYPE");
        public final static Property MajorMainId = new Property(54, long.class, "majorMainId", false, "MAJOR_MAIN_ID");
        public final static Property DeptId = new Property(55, long.class, "deptId", false, "DEPT_ID");
        public final static Property ServiceCharge = new Property(56, byte.class, "serviceCharge", false, "SERVICE_CHARGE");
        public final static Property Conditions = new Property(57, long.class, "conditions", false, "CONDITIONS");
        public final static Property IsRt = new Property(58, long.class, "isRt", false, "IS_RT");
        public final static Property Deletes = new Property(59, long.class, "deletes", false, "DELETES");
        public final static Property IsTimingFood = new Property(60, long.class, "isTimingFood", false, "IS_TIMING_FOOD");
        public final static Property MinLongTime = new Property(61, long.class, "minLongTime", false, "MIN_LONG_TIME");
        public final static Property UnitTime = new Property(62, long.class, "unitTime", false, "UNIT_TIME");
        public final static Property UnitPrice = new Property(63, double.class, "unitPrice", false, "UNIT_PRICE");
        public final static Property FreeLongTime = new Property(64, long.class, "freeLongTime", false, "FREE_LONG_TIME");
        public final static Property FreePeriodBegin = new Property(65, java.util.Date.class, "freePeriodBegin", false, "FREE_PERIOD_BEGIN");
        public final static Property IsStatistic = new Property(66, long.class, "isStatistic", false, "IS_STATISTIC");
        public final static Property ColorId = new Property(67, long.class, "colorId", false, "COLOR_ID");
    }

    private DaoSession daoSession;


    public FoodDao(DaoConfig config) {
        super(config);
    }
    
    public FoodDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"FOOD\" (" + //
                "\"FID\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"PARENT_ID\" INTEGER NOT NULL ," + // 1: parentId
                "\"RESTAURANT_ID\" INTEGER NOT NULL ," + // 2: restaurantId
                "\"IS_PARENT\" INTEGER NOT NULL ," + // 3: isParent
                "\"SEQ_NO\" INTEGER NOT NULL ," + // 4: seqNo
                "\"FOOD_NAME\" TEXT," + // 5: foodName
                "\"FOOD_NAME1\" TEXT," + // 6: foodName1
                "\"FOOD_NAME2\" TEXT," + // 7: foodName2
                "\"PLU\" TEXT," + // 8: plu
                "\"CUSTOM_TYPE\" INTEGER," + // 9: customType
                "\"POS_FID\" TEXT," + // 10: posFid
                "\"FOOD_DESC\" TEXT," + // 11: foodDesc
                "\"LIMIT_AMOUNT\" INTEGER NOT NULL ," + // 12: limitAmount
                "\"LIMIT_TYPE\" INTEGER NOT NULL ," + // 13: limitType
                "\"FOOD_SUMMARY\" TEXT," + // 14: foodSummary
                "\"INVISIBLE\" INTEGER NOT NULL ," + // 15: invisible
                "\"AUTO_MOD\" INTEGER NOT NULL ," + // 16: autoMod
                "\"PRICE\" REAL NOT NULL ," + // 17: price
                "\"MARKET_PRICE\" REAL NOT NULL ," + // 18: marketPrice
                "\"LUNCHBOX_PRICE\" REAL NOT NULL ," + // 19: lunchboxPrice
                "\"IMG_URL_SMALL\" TEXT," + // 20: imgUrlSmall
                "\"IMAGEURL\" TEXT," + // 21: imageurl
                "\"RICEPON_INVISIBLE\" INTEGER NOT NULL ," + // 22: riceponInvisible
                "\"COST\" REAL NOT NULL ," + // 23: cost
                "\"LIKE\" INTEGER NOT NULL ," + // 24: like
                "\"TOTAL_SOLD\" INTEGER NOT NULL ," + // 25: totalSold
                "\"IS_SOLD\" INTEGER NOT NULL ," + // 26: isSold
                "\"START_DATE\" INTEGER," + // 27: startDate
                "\"END_DATE\" INTEGER," + // 28: endDate
                "\"CREATE_BY\" TEXT," + // 29: createBy
                "\"CREATE_TIME\" INTEGER," + // 30: createTime
                "\"UPDATE_BY\" TEXT," + // 31: updateBy
                "\"UPDATE_TIME\" INTEGER," + // 32: updateTime
                "\"PERIOD_ID\" INTEGER NOT NULL ," + // 33: periodId
                "\"ABLE_DISCOUNT\" INTEGER NOT NULL ," + // 34: ableDiscount
                "\"TAKEAWAY\" INTEGER NOT NULL ," + // 35: takeaway
                "\"BLUE_EDIT\" INTEGER NOT NULL ," + // 36: blueEdit
                "\"CART_EDIT\" INTEGER NOT NULL ," + // 37: cartEdit
                "\"AUTO_MERGE\" INTEGER NOT NULL ," + // 38: autoMerge
                "\"PRINT_SETING\" TEXT," + // 39: printSeting
                "\"IS_PRINT_QUEUE_CODE\" INTEGER NOT NULL ," + // 40: isPrintQueueCode
                "\"QUEUE_HEAD_ID\" INTEGER NOT NULL ," + // 41: queueHeadId
                "\"APPROVE\" INTEGER NOT NULL ," + // 42: approve
                "\"PRINT_FONT\" INTEGER NOT NULL ," + // 43: printFont
                "\"ADV_PRICE\" INTEGER NOT NULL ," + // 44: advPrice
                "\"PRINT_TO_BILL\" INTEGER NOT NULL ," + // 45: printToBill
                "\"POINTS_ADD\" REAL NOT NULL ," + // 46: pointsAdd
                "\"POINTS_RATIO\" INTEGER NOT NULL ," + // 47: pointsRatio
                "\"POINTS_REDEEM\" REAL NOT NULL ," + // 48: pointsRedeem
                "\"KT_PRINT_MAIN_ITEM\" INTEGER NOT NULL ," + // 49: ktPrintMainItem
                "\"KT_SHOW_PRICE\" INTEGER NOT NULL ," + // 50: ktShowPrice
                "\"PRINT_TO\" INTEGER NOT NULL ," + // 51: printTo
                "\"TO_PAX\" INTEGER NOT NULL ," + // 52: toPax
                "\"FOOD_TYPE\" INTEGER NOT NULL ," + // 53: foodType
                "\"MAJOR_MAIN_ID\" INTEGER NOT NULL ," + // 54: majorMainId
                "\"DEPT_ID\" INTEGER NOT NULL ," + // 55: deptId
                "\"SERVICE_CHARGE\" INTEGER NOT NULL ," + // 56: serviceCharge
                "\"CONDITIONS\" INTEGER NOT NULL ," + // 57: conditions
                "\"IS_RT\" INTEGER NOT NULL ," + // 58: isRt
                "\"DELETES\" INTEGER NOT NULL ," + // 59: deletes
                "\"IS_TIMING_FOOD\" INTEGER NOT NULL ," + // 60: isTimingFood
                "\"MIN_LONG_TIME\" INTEGER NOT NULL ," + // 61: minLongTime
                "\"UNIT_TIME\" INTEGER NOT NULL ," + // 62: unitTime
                "\"UNIT_PRICE\" REAL NOT NULL ," + // 63: unitPrice
                "\"FREE_LONG_TIME\" INTEGER NOT NULL ," + // 64: freeLongTime
                "\"FREE_PERIOD_BEGIN\" INTEGER," + // 65: freePeriodBegin
                "\"IS_STATISTIC\" INTEGER NOT NULL ," + // 66: isStatistic
                "\"COLOR_ID\" INTEGER NOT NULL );"); // 67: colorId
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"FOOD\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getParentId());
        stmt.bindLong(3, entity.getRestaurantId());
        stmt.bindLong(4, entity.getIsParent());
        stmt.bindLong(5, entity.getSeqNo());
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(6, foodName);
        }
 
        String foodName1 = entity.getFoodName1();
        if (foodName1 != null) {
            stmt.bindString(7, foodName1);
        }
 
        String foodName2 = entity.getFoodName2();
        if (foodName2 != null) {
            stmt.bindString(8, foodName2);
        }
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(9, plu);
        }
 
        Integer customType = entity.getCustomType();
        if (customType != null) {
            stmt.bindLong(10, customType);
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(11, posFid);
        }
 
        String foodDesc = entity.getFoodDesc();
        if (foodDesc != null) {
            stmt.bindString(12, foodDesc);
        }
        stmt.bindLong(13, entity.getLimitAmount());
        stmt.bindLong(14, entity.getLimitType());
 
        String foodSummary = entity.getFoodSummary();
        if (foodSummary != null) {
            stmt.bindString(15, foodSummary);
        }
        stmt.bindLong(16, entity.getInvisible());
        stmt.bindLong(17, entity.getAutoMod());
        stmt.bindDouble(18, entity.getPrice());
        stmt.bindDouble(19, entity.getMarketPrice());
        stmt.bindDouble(20, entity.getLunchboxPrice());
 
        String imgUrlSmall = entity.getImgUrlSmall();
        if (imgUrlSmall != null) {
            stmt.bindString(21, imgUrlSmall);
        }
 
        String imageurl = entity.getImageurl();
        if (imageurl != null) {
            stmt.bindString(22, imageurl);
        }
        stmt.bindLong(23, entity.getRiceponInvisible());
        stmt.bindDouble(24, entity.getCost());
        stmt.bindLong(25, entity.getLike());
        stmt.bindLong(26, entity.getTotalSold());
        stmt.bindLong(27, entity.getIsSold());
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(28, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(29, endDate.getTime());
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(30, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(31, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(32, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(33, updateTime.getTime());
        }
        stmt.bindLong(34, entity.getPeriodId());
        stmt.bindLong(35, entity.getAbleDiscount());
        stmt.bindLong(36, entity.getTakeaway());
        stmt.bindLong(37, entity.getBlueEdit());
        stmt.bindLong(38, entity.getCartEdit());
        stmt.bindLong(39, entity.getAutoMerge());
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(40, printSeting);
        }
        stmt.bindLong(41, entity.getIsPrintQueueCode());
        stmt.bindLong(42, entity.getQueueHeadId());
        stmt.bindLong(43, entity.getApprove());
        stmt.bindLong(44, entity.getPrintFont());
        stmt.bindLong(45, entity.getAdvPrice());
        stmt.bindLong(46, entity.getPrintToBill());
        stmt.bindDouble(47, entity.getPointsAdd());
        stmt.bindLong(48, entity.getPointsRatio());
        stmt.bindDouble(49, entity.getPointsRedeem());
        stmt.bindLong(50, entity.getKtPrintMainItem());
        stmt.bindLong(51, entity.getKtShowPrice());
        stmt.bindLong(52, entity.getPrintTo());
        stmt.bindLong(53, entity.getToPax());
        stmt.bindLong(54, entity.getFoodType());
        stmt.bindLong(55, entity.getMajorMainId());
        stmt.bindLong(56, entity.getDeptId());
        stmt.bindLong(57, entity.getServiceCharge());
        stmt.bindLong(58, entity.getConditions());
        stmt.bindLong(59, entity.getIsRt());
        stmt.bindLong(60, entity.getDeletes());
        stmt.bindLong(61, entity.getIsTimingFood());
        stmt.bindLong(62, entity.getMinLongTime());
        stmt.bindLong(63, entity.getUnitTime());
        stmt.bindDouble(64, entity.getUnitPrice());
        stmt.bindLong(65, entity.getFreeLongTime());
 
        java.util.Date freePeriodBegin = entity.getFreePeriodBegin();
        if (freePeriodBegin != null) {
            stmt.bindLong(66, freePeriodBegin.getTime());
        }
        stmt.bindLong(67, entity.getIsStatistic());
        stmt.bindLong(68, entity.getColorId());
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getParentId());
        stmt.bindLong(3, entity.getRestaurantId());
        stmt.bindLong(4, entity.getIsParent());
        stmt.bindLong(5, entity.getSeqNo());
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(6, foodName);
        }
 
        String foodName1 = entity.getFoodName1();
        if (foodName1 != null) {
            stmt.bindString(7, foodName1);
        }
 
        String foodName2 = entity.getFoodName2();
        if (foodName2 != null) {
            stmt.bindString(8, foodName2);
        }
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(9, plu);
        }
 
        Integer customType = entity.getCustomType();
        if (customType != null) {
            stmt.bindLong(10, customType);
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(11, posFid);
        }
 
        String foodDesc = entity.getFoodDesc();
        if (foodDesc != null) {
            stmt.bindString(12, foodDesc);
        }
        stmt.bindLong(13, entity.getLimitAmount());
        stmt.bindLong(14, entity.getLimitType());
 
        String foodSummary = entity.getFoodSummary();
        if (foodSummary != null) {
            stmt.bindString(15, foodSummary);
        }
        stmt.bindLong(16, entity.getInvisible());
        stmt.bindLong(17, entity.getAutoMod());
        stmt.bindDouble(18, entity.getPrice());
        stmt.bindDouble(19, entity.getMarketPrice());
        stmt.bindDouble(20, entity.getLunchboxPrice());
 
        String imgUrlSmall = entity.getImgUrlSmall();
        if (imgUrlSmall != null) {
            stmt.bindString(21, imgUrlSmall);
        }
 
        String imageurl = entity.getImageurl();
        if (imageurl != null) {
            stmt.bindString(22, imageurl);
        }
        stmt.bindLong(23, entity.getRiceponInvisible());
        stmt.bindDouble(24, entity.getCost());
        stmt.bindLong(25, entity.getLike());
        stmt.bindLong(26, entity.getTotalSold());
        stmt.bindLong(27, entity.getIsSold());
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(28, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(29, endDate.getTime());
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(30, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(31, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(32, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(33, updateTime.getTime());
        }
        stmt.bindLong(34, entity.getPeriodId());
        stmt.bindLong(35, entity.getAbleDiscount());
        stmt.bindLong(36, entity.getTakeaway());
        stmt.bindLong(37, entity.getBlueEdit());
        stmt.bindLong(38, entity.getCartEdit());
        stmt.bindLong(39, entity.getAutoMerge());
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(40, printSeting);
        }
        stmt.bindLong(41, entity.getIsPrintQueueCode());
        stmt.bindLong(42, entity.getQueueHeadId());
        stmt.bindLong(43, entity.getApprove());
        stmt.bindLong(44, entity.getPrintFont());
        stmt.bindLong(45, entity.getAdvPrice());
        stmt.bindLong(46, entity.getPrintToBill());
        stmt.bindDouble(47, entity.getPointsAdd());
        stmt.bindLong(48, entity.getPointsRatio());
        stmt.bindDouble(49, entity.getPointsRedeem());
        stmt.bindLong(50, entity.getKtPrintMainItem());
        stmt.bindLong(51, entity.getKtShowPrice());
        stmt.bindLong(52, entity.getPrintTo());
        stmt.bindLong(53, entity.getToPax());
        stmt.bindLong(54, entity.getFoodType());
        stmt.bindLong(55, entity.getMajorMainId());
        stmt.bindLong(56, entity.getDeptId());
        stmt.bindLong(57, entity.getServiceCharge());
        stmt.bindLong(58, entity.getConditions());
        stmt.bindLong(59, entity.getIsRt());
        stmt.bindLong(60, entity.getDeletes());
        stmt.bindLong(61, entity.getIsTimingFood());
        stmt.bindLong(62, entity.getMinLongTime());
        stmt.bindLong(63, entity.getUnitTime());
        stmt.bindDouble(64, entity.getUnitPrice());
        stmt.bindLong(65, entity.getFreeLongTime());
 
        java.util.Date freePeriodBegin = entity.getFreePeriodBegin();
        if (freePeriodBegin != null) {
            stmt.bindLong(66, freePeriodBegin.getTime());
        }
        stmt.bindLong(67, entity.getIsStatistic());
        stmt.bindLong(68, entity.getColorId());
    }

    @Override
    protected final void attachEntity(Food entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Food readEntity(Cursor cursor, int offset) {
        Food entity = new Food( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getLong(offset + 1), // parentId
            cursor.getLong(offset + 2), // restaurantId
            (byte) cursor.getShort(offset + 3), // isParent
            cursor.getLong(offset + 4), // seqNo
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // foodName
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // foodName1
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // foodName2
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // plu
            cursor.isNull(offset + 9) ? null : cursor.getInt(offset + 9), // customType
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // posFid
            cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11), // foodDesc
            cursor.getLong(offset + 12), // limitAmount
            cursor.getLong(offset + 13), // limitType
            cursor.isNull(offset + 14) ? null : cursor.getString(offset + 14), // foodSummary
            cursor.getLong(offset + 15), // invisible
            (byte) cursor.getShort(offset + 16), // autoMod
            cursor.getDouble(offset + 17), // price
            cursor.getDouble(offset + 18), // marketPrice
            cursor.getDouble(offset + 19), // lunchboxPrice
            cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20), // imgUrlSmall
            cursor.isNull(offset + 21) ? null : cursor.getString(offset + 21), // imageurl
            cursor.getLong(offset + 22), // riceponInvisible
            cursor.getDouble(offset + 23), // cost
            cursor.getLong(offset + 24), // like
            cursor.getLong(offset + 25), // totalSold
            cursor.getLong(offset + 26), // isSold
            cursor.isNull(offset + 27) ? null : new java.util.Date(cursor.getLong(offset + 27)), // startDate
            cursor.isNull(offset + 28) ? null : new java.util.Date(cursor.getLong(offset + 28)), // endDate
            cursor.isNull(offset + 29) ? null : cursor.getString(offset + 29), // createBy
            cursor.isNull(offset + 30) ? null : new java.util.Date(cursor.getLong(offset + 30)), // createTime
            cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31), // updateBy
            cursor.isNull(offset + 32) ? null : new java.util.Date(cursor.getLong(offset + 32)), // updateTime
            cursor.getLong(offset + 33), // periodId
            cursor.getLong(offset + 34), // ableDiscount
            cursor.getLong(offset + 35), // takeaway
            cursor.getLong(offset + 36), // blueEdit
            cursor.getLong(offset + 37), // cartEdit
            cursor.getLong(offset + 38), // autoMerge
            cursor.isNull(offset + 39) ? null : cursor.getString(offset + 39), // printSeting
            cursor.getLong(offset + 40), // isPrintQueueCode
            cursor.getLong(offset + 41), // queueHeadId
            cursor.getLong(offset + 42), // approve
            cursor.getLong(offset + 43), // printFont
            cursor.getLong(offset + 44), // advPrice
            cursor.getLong(offset + 45), // printToBill
            cursor.getDouble(offset + 46), // pointsAdd
            cursor.getLong(offset + 47), // pointsRatio
            cursor.getDouble(offset + 48), // pointsRedeem
            cursor.getLong(offset + 49), // ktPrintMainItem
            cursor.getLong(offset + 50), // ktShowPrice
            cursor.getLong(offset + 51), // printTo
            cursor.getLong(offset + 52), // toPax
            cursor.getLong(offset + 53), // foodType
            cursor.getLong(offset + 54), // majorMainId
            cursor.getLong(offset + 55), // deptId
            (byte) cursor.getShort(offset + 56), // serviceCharge
            cursor.getLong(offset + 57), // conditions
            cursor.getLong(offset + 58), // isRt
            cursor.getLong(offset + 59), // deletes
            cursor.getLong(offset + 60), // isTimingFood
            cursor.getLong(offset + 61), // minLongTime
            cursor.getLong(offset + 62), // unitTime
            cursor.getDouble(offset + 63), // unitPrice
            cursor.getLong(offset + 64), // freeLongTime
            cursor.isNull(offset + 65) ? null : new java.util.Date(cursor.getLong(offset + 65)), // freePeriodBegin
            cursor.getLong(offset + 66), // isStatistic
            cursor.getLong(offset + 67) // colorId
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Food entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setParentId(cursor.getLong(offset + 1));
        entity.setRestaurantId(cursor.getLong(offset + 2));
        entity.setIsParent((byte) cursor.getShort(offset + 3));
        entity.setSeqNo(cursor.getLong(offset + 4));
        entity.setFoodName(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setFoodName1(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setFoodName2(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setPlu(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setCustomType(cursor.isNull(offset + 9) ? null : cursor.getInt(offset + 9));
        entity.setPosFid(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setFoodDesc(cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11));
        entity.setLimitAmount(cursor.getLong(offset + 12));
        entity.setLimitType(cursor.getLong(offset + 13));
        entity.setFoodSummary(cursor.isNull(offset + 14) ? null : cursor.getString(offset + 14));
        entity.setInvisible(cursor.getLong(offset + 15));
        entity.setAutoMod((byte) cursor.getShort(offset + 16));
        entity.setPrice(cursor.getDouble(offset + 17));
        entity.setMarketPrice(cursor.getDouble(offset + 18));
        entity.setLunchboxPrice(cursor.getDouble(offset + 19));
        entity.setImgUrlSmall(cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20));
        entity.setImageurl(cursor.isNull(offset + 21) ? null : cursor.getString(offset + 21));
        entity.setRiceponInvisible(cursor.getLong(offset + 22));
        entity.setCost(cursor.getDouble(offset + 23));
        entity.setLike(cursor.getLong(offset + 24));
        entity.setTotalSold(cursor.getLong(offset + 25));
        entity.setIsSold(cursor.getLong(offset + 26));
        entity.setStartDate(cursor.isNull(offset + 27) ? null : new java.util.Date(cursor.getLong(offset + 27)));
        entity.setEndDate(cursor.isNull(offset + 28) ? null : new java.util.Date(cursor.getLong(offset + 28)));
        entity.setCreateBy(cursor.isNull(offset + 29) ? null : cursor.getString(offset + 29));
        entity.setCreateTime(cursor.isNull(offset + 30) ? null : new java.util.Date(cursor.getLong(offset + 30)));
        entity.setUpdateBy(cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31));
        entity.setUpdateTime(cursor.isNull(offset + 32) ? null : new java.util.Date(cursor.getLong(offset + 32)));
        entity.setPeriodId(cursor.getLong(offset + 33));
        entity.setAbleDiscount(cursor.getLong(offset + 34));
        entity.setTakeaway(cursor.getLong(offset + 35));
        entity.setBlueEdit(cursor.getLong(offset + 36));
        entity.setCartEdit(cursor.getLong(offset + 37));
        entity.setAutoMerge(cursor.getLong(offset + 38));
        entity.setPrintSeting(cursor.isNull(offset + 39) ? null : cursor.getString(offset + 39));
        entity.setIsPrintQueueCode(cursor.getLong(offset + 40));
        entity.setQueueHeadId(cursor.getLong(offset + 41));
        entity.setApprove(cursor.getLong(offset + 42));
        entity.setPrintFont(cursor.getLong(offset + 43));
        entity.setAdvPrice(cursor.getLong(offset + 44));
        entity.setPrintToBill(cursor.getLong(offset + 45));
        entity.setPointsAdd(cursor.getDouble(offset + 46));
        entity.setPointsRatio(cursor.getLong(offset + 47));
        entity.setPointsRedeem(cursor.getDouble(offset + 48));
        entity.setKtPrintMainItem(cursor.getLong(offset + 49));
        entity.setKtShowPrice(cursor.getLong(offset + 50));
        entity.setPrintTo(cursor.getLong(offset + 51));
        entity.setToPax(cursor.getLong(offset + 52));
        entity.setFoodType(cursor.getLong(offset + 53));
        entity.setMajorMainId(cursor.getLong(offset + 54));
        entity.setDeptId(cursor.getLong(offset + 55));
        entity.setServiceCharge((byte) cursor.getShort(offset + 56));
        entity.setConditions(cursor.getLong(offset + 57));
        entity.setIsRt(cursor.getLong(offset + 58));
        entity.setDeletes(cursor.getLong(offset + 59));
        entity.setIsTimingFood(cursor.getLong(offset + 60));
        entity.setMinLongTime(cursor.getLong(offset + 61));
        entity.setUnitTime(cursor.getLong(offset + 62));
        entity.setUnitPrice(cursor.getDouble(offset + 63));
        entity.setFreeLongTime(cursor.getLong(offset + 64));
        entity.setFreePeriodBegin(cursor.isNull(offset + 65) ? null : new java.util.Date(cursor.getLong(offset + 65)));
        entity.setIsStatistic(cursor.getLong(offset + 66));
        entity.setColorId(cursor.getLong(offset + 67));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Food entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Food entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Food entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getColorBeanDao().getAllColumns());
            builder.append(" FROM FOOD T");
            builder.append(" LEFT JOIN COLOR_BEAN T0 ON T.\"COLOR_ID\"=T0.\"_id\"");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }
    
    protected Food loadCurrentDeep(Cursor cursor, boolean lock) {
        Food entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        ColorBean colorBean = loadCurrentOther(daoSession.getColorBeanDao(), cursor, offset);
         if(colorBean != null) {
            entity.setColorBean(colorBean);
        }

        return entity;    
    }

    public Food loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();
        
        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);
        
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }
    
    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<Food> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<Food> list = new ArrayList<Food>(count);
        
        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }
    
    protected List<Food> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }
    

    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<Food> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }
 
}
