package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.Language;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "LANGUAGE".
*/
public class LanguageDao extends AbstractDao<Language, Long> {

    public static final String TABLENAME = "LANGUAGE";

    /**
     * Properties of entity Language.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property FunctionName = new Property(1, String.class, "functionName", false, "FUNCTION_NAME");
        public final static Property LanguageName = new Property(2, String.class, "languageName", false, "LANGUAGE_NAME");
    }


    public LanguageDao(DaoConfig config) {
        super(config);
    }
    
    public LanguageDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"LANGUAGE\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"FUNCTION_NAME\" TEXT NOT NULL ," + // 1: functionName
                "\"LANGUAGE_NAME\" TEXT);"); // 2: languageName
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"LANGUAGE\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Language entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindString(2, entity.getFunctionName());
 
        String languageName = entity.getLanguageName();
        if (languageName != null) {
            stmt.bindString(3, languageName);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Language entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindString(2, entity.getFunctionName());
 
        String languageName = entity.getLanguageName();
        if (languageName != null) {
            stmt.bindString(3, languageName);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Language readEntity(Cursor cursor, int offset) {
        Language entity = new Language( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getString(offset + 1), // functionName
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2) // languageName
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Language entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setFunctionName(cursor.getString(offset + 1));
        entity.setLanguageName(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Language entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Language entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Language entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
