package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.ExpandInfo;

import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
public class ExpandInfoDaoUtils {

    private static final String TAG = ExpandInfoDaoUtils.class.getSimpleName();
    private DaoManager mManager;

    public ExpandInfoDaoUtils(Context context){
        mManager = DaoManager.getInstance();
        mManager.init(context);
    }

    /**
     * 完成Function记录的插入，如果表未创建，先创建Function表
     * @param expandInfo
     * @return
     */
    public boolean insertExpandInfo(ExpandInfo expandInfo){
        boolean flag = false;
        flag = mManager.getDaoSession().getExpandInfoDao().insert(expandInfo) == -1 ? false : true;
        Log.i(TAG, "insert expandInfo :" + flag + "-->" + expandInfo.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     * @param expandInfoList
     * @return
     */
    public boolean insertMultExpandInfo(final List<ExpandInfo> expandInfoList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (ExpandInfo expandInfo : expandInfoList) {
                        mManager.getDaoSession().insertOrReplace(expandInfo);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     * @param expandInfo
     * @return
     */
    public boolean updateExpandInfo(ExpandInfo expandInfo){
        boolean flag = false;
        try {
            mManager.getDaoSession().update(expandInfo);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     * @param expandInfo
     * @return
     */
    public boolean deleteExpandInfo(ExpandInfo expandInfo){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(expandInfo);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     * @return
     */
    public boolean deleteAll(){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(ExpandInfo.class);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     * @return
     */
    public List<ExpandInfo> queryAllExpandInfo(){
        return mManager.getDaoSession().loadAll(ExpandInfo.class);
    }

    /**
     * 根据主键id查询记录
     * @param key
     * @return
     */
    public ExpandInfo queryExpandInfoById(long key){
        return mManager.getDaoSession().load(ExpandInfo.class, key);
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<ExpandInfo> queryExpandInfoByNativeSql(String sql, String[] conditions){
        return mManager.getDaoSession().queryRaw(ExpandInfo.class, sql, conditions);
    }

}
