package com.gingersoft.gsa.cloud.pay.device.pos.base.lifecycle.fragment;

import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.order.R;
import com.gingersoft.gsa.cloud.order.R2;
import com.gingersoft.gsa.cloud.pay.PayAction;
import com.gingersoft.gsa.cloud.pay.PayStep;
import com.gingersoft.gsa.cloud.pay.RequestParms;
import com.gingersoft.gsa.cloud.pay.view.customstatus.CustomStatusView;
import com.jess.arms.base.BaseDialogFragment;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.pay.device.pos.base.lifecycle.contract.PaymentCommandContract;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/15/2021 14:44
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public abstract class PaymentCommandFragment<P extends BasePresenter> extends BaseDialogFragment<P> implements PaymentCommandContract.View {

    @BindView(R2.id.ll_container)
    LinearLayout ll_container;
    @BindView(R2.id.as_status)
    CustomStatusView as_status;
    @BindView(R2.id.tv_status)
    TextView tv_status;

    protected RequestParms requestParms;
    protected PayAction action;

    private final long mCancelDelayMillis = 2000;
    private String mLoadingText = "支付中...";

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        getDialog().setCancelable(false);
        return inflater.inflate(R.layout.dialog_command_loading, container, false);
    }

    @Override
    public void onStart() {
        super.onStart();
        mWindow.setBackgroundDrawable(new ColorDrawable(ArmsUtils.getColor(mContext, R.color.trans)));
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        requestParms = arguments.getParcelable("requestParms");
        action = requestParms.getAction();

        tv_status.setText(mLoadingText);
        ll_container.setLayoutParams(new FrameLayout.LayoutParams((int) (ArmsUtils.getScreenWidth(mContext) * 0.4), (int) (ArmsUtils.getScreenWidth(mContext) * 0.4)));

        showStatusLoadingDialog(PayStep.LOADING);
    }

    @Override
    public void showStatusLoadingDialog(PayStep status) {
        String loadingText = action.getLoadingStepText(status);
        setStatusText(loadingText);
        switch (status) {
            case LOADING:
                loadLoading();
                break;
            case SUCCESS:
                loadSuccess();
                break;
            default:
                loadFailure();
                break;
        }
    }

    public void setStatusText(String text) {
        tv_status.setText(text);
    }

    public void loadLoading() {
        as_status.loadLoading();
    }

    public void loadSuccess() {
        as_status.loadSuccess();
        killMyself();
    }

    public void loadFailure() {
        as_status.loadFailure();
        killMyself();
    }

    public void clearLoadingAnim() {
        if (as_status != null && as_status.getAnimation() != null) {
            as_status.clearAnimation();
        }
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {
    }

    @Override
    public void hideLoading() {
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        clearLoadingAnim();
        as_status.postDelayed(new Runnable() {
            @Override
            public void run() {
                dismiss();
            }
        }, mCancelDelayMillis);
    }

    public RequestParms getRequestParms() {
        return requestParms;
    }

    public PayAction getAction() {
        return action;
    }
}
