package com.gingersoft.gsa.cloud.ui.adapter.bean;

import android.text.InputFilter;

import lombok.Data;
import me.yokeyword.fragmentation.ISupportFragment;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/25
 * Time: 14:15
 * Use: 選擇類型對象
 */
@Data
public class MultiSelectBean extends MultiInputBean {
    private int requestCode;

    public MultiSelectBean(int itemType, String showTitle, boolean isRequired, String hintText, int requestCode, Class<? extends ISupportFragment> fragment) {
        super(itemType, showTitle, isRequired, hintText, null, fragment);
        this.requestCode = requestCode;
        setEdit(false);
    }

    public MultiSelectBean(int itemType, String showTitle, boolean isRequired, String hintText, int requestCode, boolean isEdit, Class<? extends ISupportFragment> fragment) {
        super(itemType, showTitle, isRequired, hintText, null, fragment);
        this.requestCode = requestCode;
        setEdit(isEdit);
    }

    public MultiSelectBean(int itemType, String showTitle, boolean isRequired, String hintText, int requestCode, boolean isEdit, InputFilter[] inputFilters, Class<? extends ISupportFragment> fragment) {
        super(itemType, showTitle, isRequired, hintText, null, fragment);
        this.requestCode = requestCode;
        setInputFilters(inputFilters);
        setEdit(isEdit);
    }
}
