package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.content.Context;

import com.chad.library.adapter.base.BaseProviderMultiAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/20
 * Time: 10:40
 * Use:
 */
public class InfoMultiAdapter extends BaseProviderMultiAdapter<InfoMultiBean> {
    public final static Object NOT_HIDE_KEYBOARD = 1001;

//    @Override
//    public void onBindViewHolder(@NotNull BaseViewHolder holder, int position) {
//        super.onBindViewHolder(holder, position);
//        holder.setIsRecyclable(false);
//    }

    @Override
    protected int getItemType(@NotNull List<? extends InfoMultiBean> list, int i) {
        return list.get(i).getItemType();
    }

    public InfoMultiAdapter(Context context, List<InfoMultiBean> infoMultiBeans) {
        super(infoMultiBeans);
        addItemProvider(new InputProvider<>());
        addItemProvider(new RemarkProvider<>());
        addItemProvider(new ThickLineProvider<>());
        addItemProvider(new TitleProvider<>());
        addItemProvider(new RadioListProvider<>(context));
        addItemProvider(new SelectDialogProvider<>(context));
        addItemProvider(new MultiUploadPicProvider<>(context));
        addItemProvider(new SelectItemProvider<>(context));
        addItemProvider(new MultiCheckProvider<>(context));
        addItemProvider(new BooleanItemProvider<>());
        addChildClickViewIds(R.id.iv_multi_upload_pic, R.id.cb_multi_check);
    }


}
