package com.gingersoft.gsa.cloud.ui.utils

import com.gingersoft.gsa.cloud.common.constans.Takeaway
import com.gingersoft.gsa.cloud.database.bean.Function
import com.gingersoft.gsa.cloud.ui.R

/**
 * 凍鏈外送都需要用到
 */
class BtnBuilder {
    lateinit var functions: List<Function>

    companion object {
        const val SureBtn = 0
        const val CancelBtn = 1
        const val PrintBtn = 2
        const val LogisticsBtn = 3
        const val AssignDeliveryBtn = 4
        const val ClosingBtn = 5
        const val ProductionCompletedBtn = 6
        const val TransportationBtn = 7//選擇運輸工具
        const val AdditionalServiceChargeBtn = 8//追加服務費
        //強制
        const val EnforceSureBtn = 9
        const val EnforceCancelBtn = 10
        const val EnforcePrintBtn = 11
        const val EnforceLogisticsBtn = 12
        const val EnforceAssignDeliveryBtn = 13
        const val EnforceClosingBtn = 14
        const val EnforceProductionCompletedBtn = 15

        @Volatile
        private var instance: BtnBuilder? = null

        @JvmStatic
        fun getInstance(functions: List<Function>): BtnBuilder {
            instance
                    ?: synchronized(this) {
                        instance
                                ?: BtnBuilder().also { instance = it }
                    }
            instance!!.functions = functions
            return instance!!
        }

    }

    class BtnBean(val type: Int, var btnContent: String, val btnColor: Int, val btnImg: Int)

    fun getSureBtn(): BtnBean? {
        return getBtn(Takeaway.CONFIRM_BTN_KEY, SureBtn, "確認訂單", R.color.other_order_details_sure_btn_color, R.drawable.ic_sure)
    }

    fun getProductionCompletedBtn(): BtnBean? {
        return getBtn(Takeaway.PRODUCTION_COMPLETED_BTN_KEY, ProductionCompletedBtn, "製作完成", R.color.other_order_details_sure_btn_color, R.drawable.ic_sure)
    }

    fun getCancelBtn(): BtnBean? {
        return getBtn(Takeaway.CANCEL_ORDER_BTN_KEY, CancelBtn, "取消訂單", R.color.other_order_details_cancel_btn_color, R.drawable.ic_cancel)
    }

    fun getPrintBtn(): BtnBean? {
        return getBtn(Takeaway.PRINT_ORDER_BTN_KEY, PrintBtn, "打印訂單", R.color.other_order_details_print_btn_color, R.drawable.ic_print)
    }

    fun getLogisticsBtn(): BtnBean? {
        return getBtn(Takeaway.LOGISTICS_BTN_KEY, LogisticsBtn, "取消物流", R.color.other_order_details_cancel_logistics_btn_color, R.drawable.ic_logistics)
    }

    fun getAssignDeliveryBtn(): BtnBean? {
        return getBtn(Takeaway.ASSIGN_DELIVERY_BTN_KEY, AssignDeliveryBtn, "指派送貨", R.color.other_order_details_sure_btn_color, R.drawable.ic_deliveryman)
    }

    fun getClosingBtn(): BtnBean? {
        return getBtn(Takeaway.CLOSING_BTN_KEY, ClosingBtn, "結賬", R.color.other_order_details_cancel_btn_color, R.drawable.ic_closing)
    }

    fun getTransportationBtn(): BtnBean? {
        return getBtn(Takeaway.TRANSPORTATION_BTN_KEY, TransportationBtn, "運輸工具", R.color.other_order_details_cancel_logistics_btn_color, R.drawable.ic_logistics)
    }

    fun getAdditionalServiceChargeBtn(): BtnBean? {
        return getBtn(Takeaway.ADDITIONAL_SERVICE_CHARGE_BTN_KEY, AdditionalServiceChargeBtn, "追加貼士", R.color.additional_service_charge_btn_color, R.drawable.ic_additional_service_charge)
    }


    fun getEnforceSureBtn(): BtnBean? {
        return getBtn(Takeaway.CONFIRM_BTN_KEY, SureBtn, "確認訂單", R.color.other_order_details_sure_btn_color, R.drawable.ic_sure)
    }

    fun getEnforceProductionCompletedBtn(): BtnBean? {
        return getBtn(Takeaway.PRODUCTION_COMPLETED_BTN_KEY, ProductionCompletedBtn, "製作完成", R.color.other_order_details_sure_btn_color, R.drawable.ic_sure)
    }

    fun getEnforceCancelBtn(): BtnBean? {
        return getBtn(Takeaway.CANCEL_ORDER_BTN_KEY, CancelBtn, "取消訂單", R.color.other_order_details_cancel_btn_color, R.drawable.ic_cancel)
    }

    fun getEnforcePrintBtn(): BtnBean? {
        return getBtn(Takeaway.PRINT_ORDER_BTN_KEY, PrintBtn, "打印訂單", R.color.other_order_details_print_btn_color, R.drawable.ic_print)
    }

    fun getEnforceLogisticsBtn(): BtnBean? {
        return getBtn(Takeaway.LOGISTICS_BTN_KEY, LogisticsBtn, "取消物流", R.color.other_order_details_cancel_logistics_btn_color, R.drawable.ic_logistics)
    }

    fun getEnforceAssignDeliveryBtn(): BtnBean? {
        return getBtn(Takeaway.ASSIGN_DELIVERY_BTN_KEY, AssignDeliveryBtn, "指派送貨", R.color.other_order_details_sure_btn_color, R.drawable.ic_deliveryman)
    }

    fun getEnforceClosingBtn(): BtnBean? {
        return getBtn(Takeaway.CLOSING_BTN_KEY, ClosingBtn, "結賬", R.color.other_order_details_cancel_btn_color, R.drawable.ic_closing)
    }


    private fun getBtn(key: String, btnCode: Int, btnContent: String, btnColor: Int, btnImg: Int): BtnBean? {
        for (value in functions) {
            if (value.resUrl == key) {
                return when (value.status) {
                    3 -> BtnBean(btnCode, btnContent, R.color.color_ccc, btnImg)
                    else -> BtnBean(btnCode, btnContent, btnColor, btnImg)
                }
            }
        }
        return null
    }
}
