package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.Discount;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "DISCOUNT".
*/
public class DiscountDao extends AbstractDao<Discount, Long> {

    public static final String TABLENAME = "DISCOUNT";

    /**
     * Properties of entity Discount.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Restaurant_id = new Property(1, Integer.class, "restaurant_id", false, "RESTAURANT_ID");
        public final static Property Amount = new Property(2, Double.class, "amount", false, "AMOUNT");
        public final static Property Discount_value = new Property(3, Double.class, "discount_value", false, "DISCOUNT_VALUE");
        public final static Property Type = new Property(4, Integer.class, "type", false, "TYPE");
        public final static Property Status = new Property(5, Integer.class, "status", false, "STATUS");
        public final static Property Remark = new Property(6, String.class, "remark", false, "REMARK");
        public final static Property Begin_time = new Property(7, java.util.Date.class, "begin_time", false, "BEGIN_TIME");
        public final static Property End_time = new Property(8, java.util.Date.class, "end_time", false, "END_TIME");
    }


    public DiscountDao(DaoConfig config) {
        super(config);
    }
    
    public DiscountDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"DISCOUNT\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"RESTAURANT_ID\" INTEGER," + // 1: restaurant_id
                "\"AMOUNT\" REAL," + // 2: amount
                "\"DISCOUNT_VALUE\" REAL," + // 3: discount_value
                "\"TYPE\" INTEGER," + // 4: type
                "\"STATUS\" INTEGER," + // 5: status
                "\"REMARK\" TEXT," + // 6: remark
                "\"BEGIN_TIME\" INTEGER," + // 7: begin_time
                "\"END_TIME\" INTEGER);"); // 8: end_time
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"DISCOUNT\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Discount entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Integer restaurant_id = entity.getRestaurant_id();
        if (restaurant_id != null) {
            stmt.bindLong(2, restaurant_id);
        }
 
        Double amount = entity.getAmount();
        if (amount != null) {
            stmt.bindDouble(3, amount);
        }
 
        Double discount_value = entity.getDiscount_value();
        if (discount_value != null) {
            stmt.bindDouble(4, discount_value);
        }
 
        Integer type = entity.getType();
        if (type != null) {
            stmt.bindLong(5, type);
        }
 
        Integer status = entity.getStatus();
        if (status != null) {
            stmt.bindLong(6, status);
        }
 
        String remark = entity.getRemark();
        if (remark != null) {
            stmt.bindString(7, remark);
        }
 
        java.util.Date begin_time = entity.getBegin_time();
        if (begin_time != null) {
            stmt.bindLong(8, begin_time.getTime());
        }
 
        java.util.Date end_time = entity.getEnd_time();
        if (end_time != null) {
            stmt.bindLong(9, end_time.getTime());
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Discount entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Integer restaurant_id = entity.getRestaurant_id();
        if (restaurant_id != null) {
            stmt.bindLong(2, restaurant_id);
        }
 
        Double amount = entity.getAmount();
        if (amount != null) {
            stmt.bindDouble(3, amount);
        }
 
        Double discount_value = entity.getDiscount_value();
        if (discount_value != null) {
            stmt.bindDouble(4, discount_value);
        }
 
        Integer type = entity.getType();
        if (type != null) {
            stmt.bindLong(5, type);
        }
 
        Integer status = entity.getStatus();
        if (status != null) {
            stmt.bindLong(6, status);
        }
 
        String remark = entity.getRemark();
        if (remark != null) {
            stmt.bindString(7, remark);
        }
 
        java.util.Date begin_time = entity.getBegin_time();
        if (begin_time != null) {
            stmt.bindLong(8, begin_time.getTime());
        }
 
        java.util.Date end_time = entity.getEnd_time();
        if (end_time != null) {
            stmt.bindLong(9, end_time.getTime());
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Discount readEntity(Cursor cursor, int offset) {
        Discount entity = new Discount( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1), // restaurant_id
            cursor.isNull(offset + 2) ? null : cursor.getDouble(offset + 2), // amount
            cursor.isNull(offset + 3) ? null : cursor.getDouble(offset + 3), // discount_value
            cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4), // type
            cursor.isNull(offset + 5) ? null : cursor.getInt(offset + 5), // status
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // remark
            cursor.isNull(offset + 7) ? null : new java.util.Date(cursor.getLong(offset + 7)), // begin_time
            cursor.isNull(offset + 8) ? null : new java.util.Date(cursor.getLong(offset + 8)) // end_time
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Discount entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setRestaurant_id(cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1));
        entity.setAmount(cursor.isNull(offset + 2) ? null : cursor.getDouble(offset + 2));
        entity.setDiscount_value(cursor.isNull(offset + 3) ? null : cursor.getDouble(offset + 3));
        entity.setType(cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4));
        entity.setStatus(cursor.isNull(offset + 5) ? null : cursor.getInt(offset + 5));
        entity.setRemark(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setBegin_time(cursor.isNull(offset + 7) ? null : new java.util.Date(cursor.getLong(offset + 7)));
        entity.setEnd_time(cursor.isNull(offset + 8) ? null : new java.util.Date(cursor.getLong(offset + 8)));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Discount entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Discount entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Discount entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
