package com.gingersoft.gsa.other_order_mode.ui.main

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.gingersoft.gsa.other_order_mode.data.WeatherRepository
import com.gingersoft.gsa.other_order_mode.data.model.bean.OrderDetails
import com.gingersoft.gsa.other_order_mode.data.model.bean.OrderList
import kotlinx.coroutines.launch

class PageViewModel(private val repository: WeatherRepository) : ViewModel() {
    companion object {
        var fragmentStatus = arrayOf("0,1,2,3", "0,1", "2", "3", "3")
        var fragmentType = arrayOf("0", "0", "0", "2", "7")
    }

    var mOrderList = arrayListOf<MutableLiveData<ArrayList<OrderList.DataBeanX.DataBean>>>()

    //其他的所有數據
    var otherInfo = MutableLiveData<OrderList.DataBeanX.DataBean>()

    //刷新狀態，有數據更新就會更改這個變量，將這個變量修改為allOrderStatus...上面五種狀態，fragment中監聽這個變量，再調用接口獲取最新數據
    var refreshState = MutableLiveData<Int>()
    //訂單號
    var orderNo: String = ""
    //手機號
    var phone: String = ""

    /**
     * 獲取訂單信息
     */
    fun getOrderList(position: Int, page: String, isLoadMore: Boolean, listener: (String) -> Unit) {
        launch({
            repository.requestOrderList(fragmentStatus[position], fragmentType[position], page, orderNo, phone).apply {
                loadInfo(listener, isLoadMore, position)
            }
        }, {
            //出錯

        })
    }

    private fun OrderList.loadInfo(listener: (String) -> Unit, isLoadMore: Boolean, position: Int) {
        listener.invoke("加載完成")
        if (getData() != null && getData()?.data != null) {
            val myData: ArrayList<OrderList.DataBeanX.DataBean> = getData()?.data as ArrayList<OrderList.DataBeanX.DataBean>
            if (myData.isNotEmpty()) {
                //取得最後一個對象，裡面有營業狀態和外賣訂單數，自取訂單數
                val dataBean: OrderList.DataBeanX.DataBean = myData[myData.size - 1]
                if (dataBean.Open_Status != null) {
                    restaurantState.value = dataBean.Open_Status!! == "1"
                }
                if (myData.size == 1) {
                    otherInfo.value = myData[0]
                } else {
                    otherInfo.value = myData[myData.size - 1]
                }
                myData.removeAt(myData.size - 1)
                if (isLoadMore) {
                    if (mOrderList[position].value != null) {
                        mOrderList[position].value!!.addAll(myData)
                    } else {
                        mOrderList[position].value = myData
                    }
                } else {
                    mOrderList[position].value = myData
                }
            } else {
                Log.e("aaa", "數據為空")
            }
        }
    }


    //餐廳營業狀態，控制按鈕
    var restaurantState = MutableLiveData<Boolean>()

    /**
     * 修改餐廳營業狀態
     */
    fun setRestaurantState(state: Boolean) {
        launch({
            repository.updateRestOpenStatus(state).apply {
                if (isSuccess()) {
                    restaurantState.value = state
                }
            }
        }, {

        })
    }

    /**
     * 根據訂單id獲取訂單詳細信息
     */
    fun getOrderInfo(orderId: String, listener: (OrderDetails) -> Unit) {
        launch({
            repository.getOrderInfo(orderId).apply {
                listener.invoke(this)
            }
        }, {
            //出錯
        })
    }


    private fun launch(block: suspend () -> Unit, error: suspend (Throwable) -> Unit) = viewModelScope.launch {
        try {
            block()
        } catch (e: Throwable) {
            error(e)
        }
    }

}