package com.gingersoft.gsa.cloud.base.common.bean;

import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-18
 * 修订历史：2020-02-18
 * 描述：訂單實體類
 */
public class OrderDetail implements Serializable {
    private static final long serialVersionUID = -958791295551999853L;
    /**
     * 是否选择
     * 0 未选中
     * 1 被选中但不是主体
     * 2 作为主体被选中
     * 3 由三级菜单进入选中全部
     */
    private int selected = 0;
    //是否食品
    private boolean isIsfood = true;
    //父級下標
    private int parentIndex = 0;
    //自身下標
    private int myIndex = 0;
    //是否是新添加的食品（未送單）
    private boolean isNew = true;
    //是否顯示
    private boolean visible = true;
    //新点后是否自动展开
    private int autoMod = 0;
    //作用于套餐下子食品的限制数量
    private int limitQty = 0;
    //折扣比例
    private double PERCENTAGE = 0.00;
    //套餐编號
    private long comid ;
    //細項編號
    private long mid;
    //修改数量前的数量
    private int changeBeforeQty = 0;
    //当前食品是否有子项
    private boolean hasChild = false;
    //背景色
    private int bgColor;
    //字體色
    private int fontColor;
    //是否组合商品 1-组合商品 2-组合商品的子商品
    private int ComboLevel = 0;
    //套餐食品是否自動跟餐
    private boolean isComboAuto = false;
    //"food" or "discount" or "modifiy"
    private int prop = FOOD_PROP;
    /**
     * 訂單Item類型
     * 1:主食品
     * 2:套餐
     * 3:細項
     * 4:折扣
     */
    public static final byte FOOD_PROP = 1;
    public static final byte COMBO_PROP = 2;
    public static final byte MODIFIER_PROP = 3;
    public static final byte DISCOUNT_PROP = 4;
    /***
     * 層級
     * 1:主食品
     * 2:子項or細項
     * 3:細項
     */
    private int itemType;
    /**
     * ID
     */
    private long id;
    /**
     * 父级ID
     */
    private long parentId;
    /**
     * 订单ID
     */
    private long orderId;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品id
     */
    private long productId;
    /**
     * 商品組id
     */
    private long topId;
    /**
     * 總價格(已經x數量)
     */
    private double price = 0;
    /**
     * 單價
     */
    private double unit_price = 0;
    /**
     * 餐盒費
     */
    private double lunchboxPrice;
    /**
     * 細項價格
     */
    private double itemsPrice;
    /**
     * 數量
     */
    private int number;
    /**
     * 已經使用優惠卷卷號列表逗號分割
     */
    private String userCouponNo;
    /**
     * 类型#1:优惠卷;2:商品;3:菜品;4:细项;5:折扣;
     */
    private byte type;
    /**
     *
     */
    private String qmUseData;
    /**
     * 备注
     */
    private String remark;
    /**
     * 细项(食品种类#食品id#详细分类ID#详细ID#名称#单价#位置索引#数量#细项总价格#posFid)
     */
    private String items;
    /**
     * 創建時間
     */
    private Date createTime = new Date();
    /**
     * 是否参与折扣#0:不參與;1:參與;
     */
    private long ablediscount;
    /**
     * 食品組
     */
    private String ftName;
    /**
     * 自定義組
     */
    private String majorName;
    /**
     * 状态#0:正常;1:删除;
     */
    private Byte status = STATUS_NORMAL;

    /**
     * 状态#0:正常;1:删除;
     */
    public static final byte STATUS_NORMAL = 0;
    public static final byte STATUS_DELETE = 1;


    /**
     * type編號#3:菜品;4:細項;5:折扣
     */
    public static final byte FOOD_TYPE = 3;
    public static final byte MODIFIER_TYPE = 4;
    public static final byte DISCOUNT_TYPE = 5;

    private String printseting;

    public OrderDetail() {
    }


    public int getSelected() {
        return selected;
    }

    public boolean isIsfood() {
        return isIsfood;
    }

    public int getParentIndex() {
        return parentIndex;
    }

    public int getMyIndex() {
        return myIndex;
    }

    public boolean isNew() {
        return isNew;
    }

    public boolean isVisible() {
        return visible;
    }

    public int getAutoMod() {
        return autoMod;
    }

    public int getLimitQty() {
        return limitQty;
    }

    public double getPERCENTAGE() {
        return PERCENTAGE;
    }

    public int getProp() {
        return prop;
    }

    public long getComid() {
        return comid;
    }

    public long getMid() {
        return mid;
    }

    public int getChangeBeforeQty() {
        return changeBeforeQty;
    }

    public boolean isHasChild() {
        return hasChild;
    }

    public int getBgColor() {
        return bgColor;
    }

    public int getFontColor() {
        return fontColor;
    }

    public int getComboLevel() {
        return ComboLevel;
    }

    public boolean isComboAuto() {
        return isComboAuto;
    }

    public long getId() {
        return id;
    }

    public long getOrderId() {
        return orderId;
    }

    public long getParentId() {
        return parentId;
    }

    public String getProductName() {
        return productName;
    }

    public long getProductId() {
        return productId;
    }

    public double getUnit_price() {
        return unit_price;
    }

    public double getLunchboxPrice() {
        return lunchboxPrice;
    }

    public double getItemsPrice() {
        return itemsPrice;
    }

    public int getNumber() {
        return number;
    }

    public String getUserCouponNo() {
        return userCouponNo;
    }

    public byte getType() {
        return type;
    }

    public String getQmUseData() {
        return qmUseData;
    }

    public String getRemark() {
        return remark;
    }

    public String getItems() {
        return items;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public long getAblediscount() {
        return ablediscount;
    }

    public String getFtName() {
        return ftName;
    }

    public String getMajorName() {
        return majorName;
    }

    public void setSelected(int selected) {
        this.selected = selected;
    }

    public void setIsfood(boolean isfood) {
        isIsfood = isfood;
    }

    public void setParentIndex(int parentIndex) {
        this.parentIndex = parentIndex;
    }

    public void setMyIndex(int myIndex) {
        this.myIndex = myIndex;
    }

    public void setNew(boolean aNew) {
        isNew = aNew;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setAutoMod(int autoMod) {
        this.autoMod = autoMod;
    }

    public void setLimitQty(int limitQty) {
        this.limitQty = limitQty;
    }

    public void setPERCENTAGE(double PERCENTAGE) {
        this.PERCENTAGE = PERCENTAGE;
    }

    public void setProp(int prop) {
        this.prop = prop;
    }

    public void setComid(long comid) {
        this.comid = comid;
    }

    public void setMid(long mid) {
        this.mid = mid;
    }

    public void setChangeBeforeQty(int changeBeforeQty) {
        this.changeBeforeQty = changeBeforeQty;
    }

    public void setHasChild(boolean hasChild) {
        this.hasChild = hasChild;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
    }

    public void setComboLevel(int comboLevel) {
        ComboLevel = comboLevel;
    }

    public void setComboAuto(boolean comboAuto) {
        isComboAuto = comboAuto;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setOrderId(long orderId) {
        this.orderId = orderId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setProductId(long productId) {
        this.productId = productId;
    }

    public void setUnit_price(double unit_price) {
        this.unit_price = unit_price;
    }

    public void setLunchboxPrice(double lunchboxPrice) {
        this.lunchboxPrice = lunchboxPrice;
    }

    public void setItemsPrice(double itemsPrice) {
        this.itemsPrice = itemsPrice;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setUserCouponNo(String userCouponNo) {
        this.userCouponNo = userCouponNo;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setQmUseData(String qmUseData) {
        this.qmUseData = qmUseData;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setAblediscount(long ablediscount) {
        this.ablediscount = ablediscount;
    }

    public void setFtName(String ftName) {
        this.ftName = ftName;
    }

    public void setMajorName(String majorName) {
        this.majorName = majorName;
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public int getItemType() {
        return itemType;
    }

    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    public String getPrintseting() {
        return printseting == null ? "" : printseting;
    }

    public void setPrintseting(String printseting) {
        this.printseting = printseting;
    }

    public long getTopId() {
        return topId;
    }

    public void setTopId(long topId) {
        this.topId = topId;
    }

    /**
     * 已送單食品轉換
     *
     * @param orderDetails
     * @return
     */
    public static List<OrderDetail> orderTransOrderDetails(List<OrderBean.OrderDetailsBean> orderDetails) {
        List<OrderDetail> orderDetailList = new ArrayList<>();
        OrderDetail parentOrderDetail = null;
        for (OrderBean.OrderDetailsBean orderDetailsBean : orderDetails) {
            OrderDetail orderDetail = new OrderDetail();
            orderDetail.setId(orderDetailsBean.getId());
            orderDetail.setProductId(orderDetailsBean.getProductId());
            orderDetail.setOrderId(orderDetailsBean.getOrderId());
            orderDetail.setParentId(orderDetailsBean.getParentId());
            orderDetail.setTopId(orderDetailsBean.getTopId());
            orderDetail.setProductName(orderDetailsBean.getProductName());
            orderDetail.setNumber(orderDetailsBean.getNumber());
            orderDetail.setPrice(orderDetailsBean.getPrice() * orderDetailsBean.getNumber());
            orderDetail.setVisible(orderDetailsBean.getStatus() == 0);
//            orderDetail.setAutomod(foods.getAutomod());
            orderDetail.setIsfood(orderDetailsBean.getType() == FOOD_TYPE);
            orderDetail.setNew(false);
            orderDetail.setType(orderDetailsBean.getType());
            orderDetail.setItemType(getItemType(orderDetailsBean, parentOrderDetail));
            orderDetailList.add(orderDetail);
            if (orderDetail.isIsfood()) {
                parentOrderDetail = orderDetail;
            }
        }
        return orderDetailList;
    }

    public static int getItemType(OrderBean.OrderDetailsBean orderDetailsBean, OrderDetail parentOrderDetail) {
        if (orderDetailsBean != null) {
            if (orderDetailsBean.getParentId() == 0) {
                return 1;
            }
            if (orderDetailsBean.getParentId() != 0 && orderDetailsBean.getType() == FOOD_TYPE) {
                return 2;
            }
            if (orderDetailsBean.getParentId() != 0 && orderDetailsBean.getType() == DISCOUNT_TYPE) {
                return 2;
            }
            if (parentOrderDetail != null && orderDetailsBean.getParentId() != 0) {
                if (parentOrderDetail.getId() == orderDetailsBean.getParentId()) {
                    //是父級
                    if (parentOrderDetail.getParentId() == 0 && orderDetailsBean.getType() == FOOD_TYPE) {
                        //第二層子食品
                        return 2;
                    }
                    if (parentOrderDetail.getParentId() == 0 && orderDetailsBean.getType() == DISCOUNT_TYPE) {
                        //第二層子食品
                        return 2;
                    }
                    if (parentOrderDetail.getParentId() != 0 && orderDetailsBean.getType() == MODIFIER_TYPE) {
                        //第三層細項
                        return 3;
                    }
                }
                return 3;
            }
        }
        return 1;
    }

    /**
     * 主食品轉換
     *
     * @param foods
     * @param number
     * @return
     */
    public static OrderDetail foodTransOrderDetails(Food foods, int number) {
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setProductName(foods.getFoodName());
        orderDetail.setTopId(foods.getTopId());
        orderDetail.setId(0);
        orderDetail.setParentId(0);
        orderDetail.setProductId(foods.getId());
//        orderDetail.setParentId(foods.getParentId());
        orderDetail.setUnit_price(foods.getPrice());
        orderDetail.setPrice(number * orderDetail.getUnit_price());
        orderDetail.setNumber(number);
        orderDetail.setOrderId(MyOrderManage.getInstance().getOrderId());
        orderDetail.setIsfood(true);
        orderDetail.setNew(true);
        orderDetail.setType(FOOD_TYPE);
        orderDetail.setItemType(1);
        orderDetail.setProp(FOOD_PROP);
        orderDetail.setAutoMod(foods.getAutoMod());
        int comboLevel = foods.isComboFood() ? 1 : 0;
        orderDetail.setComboLevel(comboLevel);
        return orderDetail;
    }

    /**
     * 套餐食品轉換
     *
     * @param foodCombo
     * @param number
     * @param prop
     * @param isRvMealClicked
     * @return
     */
    public static OrderDetail comboTransOrderDetail(ComboItem foodCombo, long id, int number, int prop, boolean isRvMealClicked) {
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setProductName(foodCombo.getName());
//        if (foodCombo.getFid() != null) {
//            orderDetail.setTopId(foodCombo.getFid());
            orderDetail.setTopId(foodCombo.getComId());
//        }
        if (foodCombo.getComId() != null) {
            orderDetail.setProductId(foodCombo.getFid());
        }
        orderDetail.setParentId(id);
        orderDetail.setUnit_price(foodCombo.getPrice());
        orderDetail.setPrice(number * orderDetail.getUnit_price());
        orderDetail.setNumber(number);
        orderDetail.setOrderId(MyOrderManage.getInstance().getOrderId());
        orderDetail.setComid(foodCombo.getComId());
        orderDetail.setIsfood(true);
        orderDetail.setNew(true);
        orderDetail.setType(FOOD_TYPE);
        orderDetail.setItemType(2);
        orderDetail.setProp(prop);
//        orderDetail.setComboAuto(foodCombo.isAutoMode());
        if (isRvMealClicked) {
            //手动点击细项 才将子食品作为主体被选中
            orderDetail.setSelected(2);
        } else {
            orderDetail.setSelected(1);
        }
        return orderDetail;
    }


    /**
     * 細項轉換
     *
     * @param modifier
     * @param number
     * @return
     */
    public static OrderDetail modifierTransOrderDetail(Modifier modifier, long id, int number) {
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setProductName(modifier.getModifierName());
        orderDetail.setTopId(modifier.getTopId());
        orderDetail.setParentId(id);
        orderDetail.setProductId(modifier.getMid());
        orderDetail.setUnit_price(modifier.getPrice());
        orderDetail.setPrice(number * orderDetail.getUnit_price());
        orderDetail.setNumber(number);
        orderDetail.setOrderId(MyOrderManage.getInstance().getOrderId());
        orderDetail.setMid(modifier.getMid());
        orderDetail.setIsfood(false);
        orderDetail.setNew(true);
        orderDetail.setType(MODIFIER_TYPE);
        orderDetail.setItemType(3);
        orderDetail.setProp(MODIFIER_PROP);
        //手动点击细项 才将子食品作为主体被选中
        orderDetail.setSelected(2);
        return orderDetail;
    }

    /**
     * 折扣轉換
     *
     * @param discount
     * @return
     */
    public static OrderDetail discountTransOrderDetail(Discount discount, double sourcePrice) {

        double discountPrice = Discount.calculationDiscount(discount,sourcePrice);

        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setProductName(discount.getRemark());
        orderDetail.setTopId(discount.getId());
        orderDetail.setParentId(discount.getId());
        orderDetail.setProductId(discount.getId());
        orderDetail.setNumber(1);
        orderDetail.setPrice(discountPrice);
        orderDetail.setUnit_price(discountPrice);
        orderDetail.setOrderId(MyOrderManage.getInstance().getOrderId());
        orderDetail.setIsfood(false);
        orderDetail.setNew(true);
        orderDetail.setType(DISCOUNT_TYPE);
        orderDetail.setItemType(2);
        orderDetail.setProp(DISCOUNT_PROP);
        orderDetail.setSelected(2);
        return orderDetail;
    }

}
