package com.gingersoft.supply_chain.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.utils.CollectionUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.mvp.bean.PurchaseWarehousingOrderDetailsVO;
import com.gingersoft.supply_chain.mvp.bean.WareHouseListBean;
import com.gingersoft.supply_chain.mvp.content.PurchaseConstant;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;

import javax.inject.Inject;

import com.gingersoft.supply_chain.mvp.contract.WareHouseListContract;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/06/2021 15:37
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class WareHouseListPresenter extends BasePresenter<WareHouseListContract.Model, WareHouseListContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    public final int SORT_UNIT_PRICE = 1;
    public final int SORT_WAREHOUSING_NUM = 2;
    public final int SORT_TOTAL_AMOUNT = 3;

    @Inject
    public WareHouseListPresenter(WareHouseListContract.Model model, WareHouseListContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    /**
     * 跟進類型排序
     *
     * @param type        類型
     * @param isAscending 升序或降序
     */
    public void sortByType(int type, boolean isAscending, List<PurchaseWarehousingOrderDetailsVO> purchaseWarehousingOrderDetailsVOS) {
        if (CollectionUtils.isNullOrEmpty(purchaseWarehousingOrderDetailsVOS)) {
            return;
        }
        if (type == SORT_UNIT_PRICE) {
            Collections.sort(purchaseWarehousingOrderDetailsVOS, (o1, o2) -> {
                if (isAscending) {
                    return (int) (o1.getFoodPrice() - o2.getFoodPrice());
                } else {
                    return (int) (o2.getFoodPrice() - o1.getFoodPrice());
                }
            });
        } else if (type == SORT_WAREHOUSING_NUM) {
            //庫存數量
            Collections.sort(purchaseWarehousingOrderDetailsVOS, (o1, o2) -> {
                if (isAscending) {
                    return o1.getFoodNum() - o2.getFoodNum();
                } else {
                    return o2.getFoodNum() - o1.getFoodNum();
                }
            });
        } else if (type == SORT_TOTAL_AMOUNT) {
            //總價
            Collections.sort(purchaseWarehousingOrderDetailsVOS, (o1, o2) -> {
                if (isAscending) {
                    return (int) (o1.getFoodAmount() - o2.getFoodAmount());
                } else {
                    return (int) (o2.getFoodAmount() - o1.getFoodAmount());
                }
            });
        }
        mRootView.loadSortData(purchaseWarehousingOrderDetailsVOS);
    }

    public void getWarehousing(int pageIndex, String foodName) {
        Map<String, Object> map = new HashMap<>(5);
        if (TextUtil.isNotEmptyOrNullOrUndefined(foodName)) {
            map.put("name", foodName);
        }
        PurchaseConstant.addRestaurantId(map);
        PurchaseConstant.addBrandId(map);
        map.put("pageSize", 30);
        map.put("pageIndex", pageIndex * 30);
        mModel.getWarehousing(map)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(PurchaseConstant.GET_INFO_LOADING))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<WareHouseListBean>(mErrorHandler) {
                    @Override
                    public void onNext(WareHouseListBean wareHouseListBean) {
                        if (wareHouseListBean.isSuccess()) {
//                            if (data == null || pageIndex == 0) {
//                                data = new WareHouseListBean.WareHousingDataBean();
//                                data.setPurchaseWarehousingOrderDetailsVOS(new ArrayList<>());
//                                data.getPurchaseWarehousingOrderDetailsVOS().add(new PurchaseWarehousingOrderDetailsVO());
//                            }
//                            data.setTotal(wareHouseListBean.getData().getTotal());
                            if (CollectionUtils.isNullOrEmpty(wareHouseListBean.getData().getPurchaseWarehousingOrderDetailsVOS())) {
                                mRootView.finishLoadNoMoreData();
                            } else {
                                mRootView.loadWarehousingInfo(wareHouseListBean.getData());
                            }
//                            data.getPurchaseWarehousingOrderDetailsVOS().addAll(wareHouseListBean.getData().getPurchaseWarehousingOrderDetailsVOS());
                        } else if (TextUtil.isNotEmptyOrNullOrUndefined(wareHouseListBean.getErrMsg())) {
                            mRootView.showMessage(wareHouseListBean.getErrMsg());
                            mRootView.loadFail();
                        } else {
                            mRootView.showMessage(PurchaseConstant.GET_INFO_ERROR);
                            mRootView.loadFail();
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mRootView.loadFail();
                    }
                });
    }
}
