package com.gingersoft.gsa.cloud.user.login.mvp.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.user.login.R;
import com.gingersoft.gsa.cloud.user.login.mvp.bean.GuideBean;

import java.util.List;

import static com.jess.arms.utils.DeviceUtils.getScreenWidth;

public class GuideAdapter extends RecyclerView.Adapter<GuideAdapter.BaseViewHolder> {

    private List<GuideBean> guideBeanList;
    private Context mContext;

    public GuideAdapter(Context mContext, List<GuideBean> guideBeanList) {
        this.guideBeanList = guideBeanList;
        this.mContext = mContext;
    }

    @NonNull
    @Override
    public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new BaseViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_guide, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position) {
        GuideBean item = guideBeanList.get(position);
        holder.title.setText(item.getTitle());
        holder.details.setText(item.getDetails());

        ViewGroup.LayoutParams params = holder.img.getLayoutParams();
        if (position == 0) {
            params.width = (int) (getScreenWidth(mContext) * 0.75);
            params.height = (int) (params.width * 1.04);
        } else if (position == 1) {
            params.width = ViewGroup.LayoutParams.MATCH_PARENT;
            params.height = (int) (params.width * 1.04);
        } else if (position == 2) {
            params.width = (int) (getScreenWidth(mContext) * 0.8);
            params.height = (int) (params.width * 1.1);
        }
        holder.img.setLayoutParams(params);
        holder.img.setImageDrawable(item.getImg());
    }

    @Override
    public int getItemCount() {
        return guideBeanList == null ? 0 : guideBeanList.size();
    }

    public class BaseViewHolder extends RecyclerView.ViewHolder {

        private TextView title;
        private TextView details;
        private ImageView img;

        public BaseViewHolder(@NonNull View itemView) {
            super(itemView);
            title = itemView.findViewById(R.id.tv_title);
            details = itemView.findViewById(R.id.tv_details);
            img = itemView.findViewById(R.id.iv_guide_img);
        }
    }


}
