package com.gingersoft.supply_chain.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.FoodByCategoryResultBean;
import com.gingersoft.supply_chain.mvp.bean.FoodListInfoBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.server.SupplierServer;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.supply_chain.mvp.contract.BuyIngredientsContract;

import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/10/2021 14:55
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class BuyIngredientsModel extends BaseModel implements BuyIngredientsContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public BuyIngredientsModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<FoodListInfoBean> getFoodIngredientsData(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getFoodIngredientsData(map);
    }

    @Override
    public Observable<BaseResult> getFoodBySupplierId(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getFoodBySupplierId(map);
    }

    @Override
    public Observable<BaseResult> searchFoodBySupplierId(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).searchFoodBySupplierId(map);
    }

    @Override
    public Observable<BaseResult> deleteFood(int foodId) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).deleteFood(foodId);
    }

    @Override
    public Observable<OrderCategoryBean> getCategoryTrees(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getCategoryTrees(map);
    }

    @Override
    public Observable<FoodByCategoryResultBean> getFoodByCategory(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getFoodByCategory(map);
    }

}