package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.widget.EditText;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.common.utils.inputFilter.DecimalDigitsInputFilter;
import com.gingersoft.gsa.cloud.common.utils.inputFilter.InputFilterUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.DeputyUnitBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/29
 * Time: 16:31
 * Use:
 */
public class DeputyUnitAdapter extends BaseQuickAdapter<DeputyUnitBean, BaseViewHolder> {

    public DeputyUnitAdapter(@Nullable List<DeputyUnitBean> data) {
        super(R.layout.item_deputy_unit, data);
        addChildClickViewIds(R.id.iv_deputy_unit_delete);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, DeputyUnitBean item) {
        EditText edDeputyUnitName = viewHolder.getView(R.id.ed_deputy_unit_name);
        EditText edConversionMultiple = viewHolder.getView(R.id.ed_deputy_unit_conversion_multiple);
        viewHolder.setText(R.id.tv_deputy_unit_title, "副單位" + (viewHolder.getAdapterPosition() + 1));
        viewHolder.setText(R.id.ed_deputy_unit_name, item.getDeputyUnit());

        viewHolder.setText(R.id.ed_deputy_unit_conversion_multiple, MoneyUtil.formatDouble(item.getConversionMultiple()));
        //副單位換算倍數
        TextWatcher deputyUnitNameWatcher = new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                DeputyUnitBean deputyUnitBean = getData().get(viewHolder.getAdapterPosition());
                deputyUnitBean.setDeputyUnit(s + "");
            }
        };
        //副單位名稱輸入框  mod by zjs 填寫商品單位
        edDeputyUnitName.setFilters(new InputFilter[]{InputFilterUtils.getLengthFilter(getContext(), 5),
                new DecimalDigitsInputFilter(getContext(), 3)});
        setFocusChangeListener(edDeputyUnitName, deputyUnitNameWatcher);
        TextWatcher conversionMultipleWatcher = new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                DeputyUnitBean deputyUnitBean = getData().get(viewHolder.getAdapterPosition());
                if (TextUtil.isNotEmptyOrNullOrUndefined(s + "")) {
                    deputyUnitBean.setConversionMultiple(Double.parseDouble(s + ""));
                } else {
                    deputyUnitBean.setConversionMultiple(Double.parseDouble("0"));
                    edConversionMultiple.setText("0");
                }
            }
        };
        setFocusChangeListener(edConversionMultiple, conversionMultipleWatcher);
        edConversionMultiple.setFilters(new InputFilter[]{InputFilterUtils.getNumberFilter(edDeputyUnitName.getContext())});
        if (TextUtil.isEmptyOrNullOrUndefined(item.getDeputyUnit())) {
            edDeputyUnitName.requestFocus();
        }
    }

    private void setFocusChangeListener(EditText edDeputyUnitName, TextWatcher deputyUnitNameWatcher) {
        edDeputyUnitName.setOnFocusChangeListener((v, hasFocus) -> {
            if (hasFocus) {
                edDeputyUnitName.addTextChangedListener(deputyUnitNameWatcher);
            } else {
                edDeputyUnitName.removeTextChangedListener(deputyUnitNameWatcher);
            }
        });
    }
}
