package com.gingersoft.gsa.cloud.common.constans;

import android.content.Context;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.yanzhenjie.recyclerview.widget.BorderItemDecoration;

import java.util.Map;

import lombok.NonNull;
import okhttp3.FormBody;

/**
 * Created by Wyh on 2019/12/21.
 */
public class AppConstant {
    /**
     * 供應鏈首頁action
     */
    public static final String SUPPLY_CHAIN_MAIN_ACTION = "supply_chain_main_action";

    public static final String RP_HEART_ERROR = "RP_HD001";//心跳斷開錯誤碼
    public static final String RP_ORDER_LIST_ERROR = "RP_OL002";//訂單列表錯誤碼
    public static final String RP_THIRE_LOGISTICS_ERROR = "RP_WL003";//第三方物流接口錯誤碼
    public static final String RP_UPDATE_ORDER_STATE_ERROR = "RP_UO004";//修改訂單狀態失敗錯誤碼
    public static final String RP_LOGIN_ERROR = "RP_LOGIN";//登陸報錯錯誤碼
    public static final String RP_REPRINT_CODE = "RP_REPRINT_CODE";//重印推送
    public static final String RP_ERROR = "RP_ERROR";//全局報錯錯誤碼


    public static final String SECRETKEY_VALUES = "2309485937845783";

    public static final String APP_TYPE = "9";

    public static final String VIBRATION_PROGRESS = "vibration_progress";//震动强度
    public static final String PRESSSOUND_PROGRESS = "presssound_progress";//按键音量

    public static final String CARSH_STR = "$";

    public static final String CLEAR_ORDER_RECEIVING_HEART = "CLEAR_ORDER_RECEIVING_HEART";

    /**
     * 語言下標
     */
    public static final String LANGUAGE_INDEX = "language_index";

    /**
     * 香港，大陸電話號碼長度
     */
    public static final int MOBILE_TYPE_HK_LENGTH = 8;
    public static final int MOBILE_TYPE_CH_LENGTH = 11;

    /**
     * 逗號分隔符
     */
    public static final String COMMA_SEPARATED = ",";

    public static final String GET_INFO_ERROR = "數據獲取失敗，請稍候再試";
    public static final String INFO_SYNTAX_ERROR = "數據解析失敗，請聯繫開發人員";
    public static final String GET_INFO_LOADING = "數據獲取中...";
    public static final String QUERY_LOADING = "查詢中...";

    public static final String IMG_UPLOAD_LOADING = "圖片上傳中...";
    public static final String IMG_UPLOAD_FAIL = "圖片上傳失敗，請稍後重試";

    public static final String NULL_INFO_ERROR = "未獲取到數據，請退出後重試";
    public static final String SAVE_LOADING = "保存中...";
    public static final String SAVE_SUCCESS = "保存成功";
    public static final String SAVE_FAIL = "保存失敗，請稍後重試";
    public static final String UPDATE_LOADING = "修改中...";
    public static final String UPDATE_SUCCESS = "修改成功";
    public static final String UPDATE_FAIL = "修改失敗，請稍後重試";

    public static final String DELETE_LOADING = "刪除中...";
    public static final String DELETE_SUCCESS = "刪除成功";
    public static final String DELETE_FAIL = "刪除失敗，請稍後重試";

    public static final int PAGE_SIZE = 10;

    public static int getBrandId() {
        return RestaurantInfoManager.newInstance().getBrandId();
//        return BuildConfig.DEBUG ? 1 : RestaurantInfoManager.newInstance().getBrandId();
    }

    public static int getRestaurantId() {
        return RestaurantInfoManager.newInstance().getRestaurantId();
//        return BuildConfig.DEBUG ? 26 : RestaurantInfoManager.newInstance().getRestaurantId();
    }

    public static void addBrandId(@NonNull Map<String, Object> map) {
        map.put("brandId", getBrandId());
    }

    public static void addRestaurantId(@NonNull Map<String, Object> map) {
        map.put("restaurantId", getRestaurantId());
    }

    public static void addBrandId(@NonNull FormBody.Builder builder) {
        builder.add("brandId", String.valueOf(getBrandId()));
    }

    public static void addRestaurantId(@NonNull FormBody.Builder builder) {
        builder.add("restaurantId", String.valueOf(getRestaurantId()));
    }


    public static void addPageSize(Map<String, Object> map) {
        map.put("pageSize", PAGE_SIZE);
    }

    public static void addPageIndex(Map<String, Object> map, int pageIndex) {
        map.put("pageIndex", pageIndex * PAGE_SIZE);
    }

    public static RecyclerView.ItemDecoration getItemDecoration(Context context) {
        return new BorderItemDecoration(ContextCompat.getColor(context, R.color.color_ccc));
    }
}
