package com.gingersoft.gsa.cloud.order.discount;

import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;

import lombok.Getter;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-19
 * 修订历史：2020-09-19
 * 描述: 會員等級折扣{@link MemberInfo#memberDiscount}
 */
@Getter
public class MemberLevelDiscount extends MultyDiscount {

    private MemberInfo memberDiscount;

    public MemberLevelDiscount(String name, int status, MultyDiscount nextMultyDiscount, MemberInfo memberDiscount) {
        super(name, status,nextMultyDiscount);
        this.memberDiscount = memberDiscount;
    }

    @Override
    public double calculate(double money) {
        if (memberDiscount != null) {
            discountMoney = calculationMemberDiscount(memberDiscount.getMemberDiscount(), money);
            money = MoneyUtil.sum(money,discountMoney);
        }
        return super.calculate(money);
    }

    public static double calculationMemberDiscount(int discountRate, double sourceMoney) {
        double discountMoney = MoneyUtil.divide(MoneyUtil.multiply(sourceMoney, discountRate), 100).doubleValue();
        if (sourceMoney < discountMoney) {
            //折扣金額不能超出總額
            discountMoney = sourceMoney;
        }
        return -MoneyUtil.get_ItemDecimals_money(Math.abs(discountMoney));
    }
}
