package com.joe.print.mvp.print.utils;

import android.content.Context;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.database.utils.PrintCurrencyDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.PrinterDeviceDaoUtils;
import com.joe.print.R;

import java.util.List;

public class MyPrintUtils {

    private final int HEADER_TEXTSIZE = 26;

    private static MyPrintUtils myPrintUtils;

    private static boolean isUpdateCurrencyBeans = false;
    private static List<PrintCurrencyBean> printCurrencyBeans;//通用打印配置

    public static MyPrintUtils getInstance() {
        if (myPrintUtils == null) {
            myPrintUtils = new MyPrintUtils();
        }
        return myPrintUtils;
    }


    /**
     * 通過類型獲取打印通用配置
     *
     * @param context
     * @param type    1：堂食，2：外送，3：skyorder下單
     * @return
     */
    public static PrintCurrencyBean getPrintCurrencyBeanByType(Context context, int type) {
        if (isUpdateCurrencyBeans || printCurrencyBeans == null || printCurrencyBeans.size() == 0) {
            PrintCurrencyDaoUtils printCurrencyDaoUtils = new PrintCurrencyDaoUtils(context);
            printCurrencyBeans = printCurrencyDaoUtils.queryAllPrintCurrencyBean();
        }
        for (PrintCurrencyBean printCurrencyBean : printCurrencyBeans) {
            if (printCurrencyBean.getType() == type) {
                return printCurrencyBean;
            }
        }
        return null;
    }

    /**
     * 獲取打印通用配置集合
     *
     * @param context
     * @return
     */
    public static List<PrintCurrencyBean> getPrintCurrencyBeans(Context context) {
        if (isUpdateCurrencyBeans || printCurrencyBeans == null || printCurrencyBeans.size() == 0) {
            PrintCurrencyDaoUtils printCurrencyDaoUtils = new PrintCurrencyDaoUtils(context);
            printCurrencyBeans = printCurrencyDaoUtils.queryAllPrintCurrencyBean();
        }
        return printCurrencyBeans;
    }

    /**
     * 通過打印位置獲取打印機
     *
     * @param context
     * @param printerDeviceName 打印機名稱：打印機位置
     * @return
     */
    public PrinterDeviceBean getPrinterDeviceByLocation(Context context, String printerDeviceName) {
        PrinterDeviceDaoUtils printerDeviceDaoUtils = new PrinterDeviceDaoUtils(context);
        List<PrinterDeviceBean> printerDeviceBeans = printerDeviceDaoUtils.queryAllPrinterDeviceBean();
        if (printerDeviceBeans != null && printerDeviceBeans.size() > 0) {
            for (PrinterDeviceBean printerDevice : printerDeviceBeans) {
                if (printerDevice.getName() != null && printerDevice.getName().equals(printerDeviceName)) {
                    return printerDevice;
                }
            }
        }
        printerDeviceDaoUtils.closeConnection();
        return null;
    }

    /**
     * 獲取默認打印機
     *
     * @param context
     * @return
     */
    public PrinterDeviceBean getDefaultPrinterDevice(Context context) {
        PrinterDeviceDaoUtils printerDeviceDaoUtils = new PrinterDeviceDaoUtils(context);
        List<PrinterDeviceBean> printerDeviceBeans = printerDeviceDaoUtils.queryAllPrinterDeviceBean();
        if (printerDeviceBeans != null && printerDeviceBeans.size() > 0) {
            for (PrinterDeviceBean printerDevice : printerDeviceBeans) {
                if (printerDevice.getPrinterDeviceDefaultId() != null) {
                    return printerDevice;
                }
            }
        }
        printerDeviceDaoUtils.closeConnection();
        return null;
    }

    /**
     * 配置打印機屬性，因為有部分屬性是預設的，如果是預設的，就取通用打印配置
     */
    public static PrinterDeviceBean configPrinterProperties(PrintCurrencyBean printCurrencyBean, PrinterDeviceBean defaultPrint) {
        if (printCurrencyBean != null && defaultPrint != null) {
            if (defaultPrint.getFoodIsBold() == 0) {
                defaultPrint.setFoodIsBold(printCurrencyBean.getFoodIsBold());
            }
            if (PrinterDeviceBean.DEFAULT_FONT_SIZE.equals(defaultPrint.getFoodFont())) {
                defaultPrint.setFoodFont(printCurrencyBean.getFoodFont());
            }
            if (defaultPrint.getFoodIsItalic() == 0) {
                defaultPrint.setFoodIsItalic(printCurrencyBean.getFoodIsItalic());
            }
            if (defaultPrint.getModifierIsBold() == 0) {
                defaultPrint.setModifierIsBold(printCurrencyBean.getModifierIsBold());
            }
            if (PrinterDeviceBean.DEFAULT_FONT_SIZE.equals(defaultPrint.getModifierFont())) {
                defaultPrint.setModifierFont(printCurrencyBean.getModifierFont());
            }
            if (defaultPrint.getModifierIsItalic() == 0) {
                defaultPrint.setModifierIsItalic(printCurrencyBean.getModifierIsItalic());
            }
            if (defaultPrint.getNumberIsFlip() == 0) {
                defaultPrint.setNumberIsFlip(printCurrencyBean.getNumberIsFlip());
            }
        }
        if (printCurrencyBean == null) {
            // 如果沒有預設，那麼判斷打印機字體大小是不是設置為預設
            // 如果是預設，那麼手動給設置食品字體大小，不然打印不出來食品
            if (PrinterDeviceBean.DEFAULT_FONT_SIZE.equals(defaultPrint.getFoodFont())) {
                defaultPrint.setFoodFont("18");
            }
            if (PrinterDeviceBean.DEFAULT_FONT_SIZE.equals(defaultPrint.getModifierFont())) {
                defaultPrint.setModifierFont("16");
            }
        }
        return defaultPrint;
    }

    public TextView getBrandName(Context context) {
        return getNormalTextView(context, RestaurantInfoManager.newInstance().getBrandName(), HEADER_TEXTSIZE);
    }

    public TextView getRestaurantName(Context context) {
        return getNormalTextView(context, RestaurantInfoManager.newInstance().getRestaurantName(), HEADER_TEXTSIZE);
    }

    public TextView getDashedLine(Context context) {
        TextView textView = getNormalTextView(context, context.getString(R.string.print_split_line), HEADER_TEXTSIZE);
        textView.setSingleLine(true);
        return textView;
    }

    public TextView getNormalTextView(Context context, String text, int textSize) {
        TextView textView = new TextView(context);
        textView.setText(text);
        textView.setTextSize(textSize);
        return textView;
    }


    public static Object getContentByLength(Object[] text, int i) {
        if (text.length == 1) {
            return text[0];
        } else {
            return text[i];
        }
    }


    private static String abc = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    /**
     * 如果超過紙張寬度的英文，換行時，要截取得當
     * 23
     *
     * @return
     */
    public static String getFormatText(String content, int paperWidth) {
        if (content.length() > paperWidth) {
            int lastIndex = 0;//上次截取時最後的下標
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                if (lastIndex + paperWidth >= content.length()) {
                    String footStr = content.substring(lastIndex);
                    stringBuilder.append(footStr);
                    return stringBuilder.toString();
                } else {
                    String headerStr = content.substring(lastIndex, lastIndex + paperWidth);
                    String nextContext = content.substring(lastIndex + paperWidth, lastIndex + paperWidth + 1);
                    if (abc.contains(headerStr.charAt(headerStr.length() - 1) + "") && abc.contains(nextContext)) {
                        //如果最後一位是英文單詞，往前找找到空格或者不是英文的，然後換行
                        for (int j = headerStr.length() - 1; j >= 0; j--) {
                            String tchar = headerStr.charAt(j) + "";
                            if (j == 0) {
                                //循環完了都沒找到，就不管了
                                stringBuilder.append(headerStr);
                                stringBuilder.append("\n");
                                lastIndex += paperWidth;
                                break;
                            }
                            if (!abc.contains(tchar)) {
                                //找到不是英文的那個
                                String newHeaderStr = headerStr.substring(0, j + 1);
                                stringBuilder.append(newHeaderStr);
                                stringBuilder.append("\n");
                                lastIndex += j + 1;
                                break;
                            }
                        }
                    } else {
                        lastIndex += paperWidth;
                        stringBuilder.append(headerStr);
                        stringBuilder.append("\n");
                    }
                }
            }
        } else {
            return content;
        }
    }
//    private void setLanguage(String language) throws Epos2Exception {
//        if ("en".equals(language)) {
//            //切換對應語言
//            mPrinter.addTextLang(Printer.LANG_EN);
//        } else if ("ja".equals(language)) {
//            mPrinter.addTextLang(Printer.LANG_JA);
//        } else if ("cn".equals(language)) {
//            mPrinter.addTextLang(Printer.LANG_ZH_CN);
//        } else if ("tw".equals(language)) {
//            mPrinter.addTextLang(Printer.LANG_ZH_TW);
//        } else if ("ko".equals(language)) {
//            mPrinter.addTextLang(Printer.LANG_KO);
//        } else if ("th".equals(language)) {
//            mPrinter.addTextLang(Printer.LANG_TH);
//        } else if ("vi".equals(language)) {
//            mPrinter.addTextLang(Printer.LANG_VI);
//        } else if ("multi".equals(language)) {
//            mPrinter.addTextLang(Printer.LANG_MULTI);
//        }
//    }

    public static double getChineseValueLength(String value) {
        double valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); i++) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 1.5;
            } else {
                valueLength += 1;
            }
        }
        return valueLength;
    }

}
