package com.joe.print.mvp.print;

import android.content.Context;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.ui.dialog.LoadingDialog;

import am.util.printer.PrintExecutor;
import am.util.printer.PrintSocketHolder;
import am.util.printer.PrinterWriter58mm;

/**
 * Created by Wyh on 2020/1/15.
 */
public class Print implements PrintSocketHolder.OnStateChangedListener, PrintExecutor.OnPrintResultListener {
    private PrintExecutor executor;
    private SendPrint maker;
    private static Print print;
    private Context mContext;
    public static Print getInstance() {
        synchronized (Print.class) {
            if (print == null) {
                print = new Print();
            }
        }
        return print;
    }

    public void printOrder(Context context) {
        this.mContext = context;
        LoadingDialog.showNewDialogForLoading(GsaCloudApplication.getAppContext(),"初始化...",false);
        if (executor == null) {
            executor = new PrintExecutor("192.168.1.217", 9100, PrinterWriter58mm.TYPE_58);
            executor.setOnStateChangedListener(this);
            executor.setOnPrintResultListener(this);
        }
        if (maker == null) {
            maker = new SendPrint(context, 255, 580);
        }
        executor.setIp("192.168.1.218", 9100);
        executor.doPrinterRequestAsync(maker);
    }


    @Override
    public void onResult(int errorCode) {
        String msg;
        switch (errorCode) {
            case PrintSocketHolder.ERROR_0:
                //打印成功
                msg = "打印成功";
                break;
            case PrintSocketHolder.ERROR_2:
                //创建Socket失败
                msg = "連接打印機失敗";
                break;
            case PrintSocketHolder.ERROR_1:
            case PrintSocketHolder.ERROR_3:
            case PrintSocketHolder.ERROR_4:
            case PrintSocketHolder.ERROR_5:
                default:
                //打印失敗
                    msg = "打印失敗";
//                    LoadingDialog.cancelDialogForLoading();
                    break;
        }
        LoadingDialog.setText(msg);
    }

    @Override
    public void onStateChanged(int state) {
        String msg = "";
        switch (state) {
            case PrintSocketHolder.STATE_0:
            case PrintSocketHolder.STATE_1:
                //创建Socket连接
                msg = "連接打印機...";
                break;
            case PrintSocketHolder.STATE_2:
            case PrintSocketHolder.STATE_3:
                //写入测试页面数据
                msg = "正在打印...";
                break;
            case PrintSocketHolder.STATE_4:
                msg = "正在關閉...";
//                LoadingDialog.cancelDialogForLoading();
                break;
        }
        LoadingDialog.setText(msg);
    }
}
