package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.greendao.FoodDao;

import org.greenrobot.greendao.query.QueryBuilder;

import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
public class FoodDaoUtils {

    private static final String TAG = FoodDaoUtils.class.getSimpleName();
    private DaoManager mManager;

    public FoodDaoUtils(Context context){
        mManager = DaoManager.getInstance();
        mManager.init(context);
    }

    /**
     * 完成Food记录的插入，如果表未创建，先创建Food表
     * @param Food
     * @return
     */
    public boolean insertFood(Food Food){
        boolean flag = false;
        flag = mManager.getDaoSession().getFoodDao().insert(Food) == -1 ? false : true;
        Log.i(TAG, "insert Food :" + flag + "-->" + Food.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     * @param foodList
     * @return
     */
    public boolean insertMultFood(final List<Food> foodList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (Food Food : foodList) {
                        mManager.getDaoSession().insertOrReplace(Food);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     * @param food
     * @return
     */
    public boolean updateFood(Food food){
        boolean flag = false;
        try {
            mManager.getDaoSession().update(food);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     * @param food
     * @return
     */
    public boolean deleteFood(Food food){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(food);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     * @return
     */
    public boolean deleteAll(){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(Food.class);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     * @return
     */
    public List<Food> queryAllFood(){
        return mManager.getDaoSession().loadAll(Food.class);
    }

    /**
     * 根据主键id查询记录
     * @param key
     * @return
     */
    public Food queryFoodById(long key){
        return mManager.getDaoSession().load(Food.class, key);
    }


    /**
     * 使用native sql进行查询操作
     */
    public List<Food> queryFoodByNativeSql(String sql, String[] conditions){
        return mManager.getDaoSession().queryRaw(Food.class, sql, conditions);
    }

    /**
     * 使用queryBuilder进行查询食品組
     * @return
     */
    public List<Food> queryFoodGroupByQueryBuilder(){
        QueryBuilder<Food> queryBuilder = mManager.getDaoSession().queryBuilder(Food.class);
        return queryBuilder.where(FoodDao.Properties.ParentId.le(0)).list();
    }

    /**
     * 使用queryBuilder进行查询食品
     * @return
     */
    public List<Food> queryFoodByQueryBuilder(long parentId){
        QueryBuilder<Food> queryBuilder = mManager.getDaoSession().queryBuilder(Food.class);
        return queryBuilder.where(FoodDao.Properties.ParentId.eq(parentId)).list();
    }

    /**
     * 使用queryBuilder进行查询食品
     * @return
     */
    public Food queryFoodByQueryBuilder(String plu){
        QueryBuilder<Food> queryBuilder = mManager.getDaoSession().queryBuilder(Food.class);
        return queryBuilder.where(FoodDao.Properties.Plu.eq(plu)).build().unique();
    }

}
