package com.gingersoft.coldchain_module.di.module;

import com.gingersoft.coldchain_module.mvp.contract.OrderListContract;
import com.gingersoft.coldchain_module.mvp.model.OrderListModel;
import com.jess.arms.di.scope.FragmentScope;

import dagger.Module;
import dagger.Provides;


@Module
public class OrderListModule {
    private OrderListContract.View view;

    /**
     * 构建OrderListModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     *
     * @param view
     */
    public OrderListModule(OrderListContract.View view) {
        this.view = view;
    }

    @FragmentScope
    @Provides
    OrderListContract.View provideOrderListView() {
        return this.view;
    }

    @FragmentScope
    @Provides
    OrderListContract.Model provideOrderListModel(OrderListModel model) {
        return model;
    }
}