package com.gingersoft.gsa.delivery_pick_mode.ui.adapter

import android.animation.AnimatorSet
import android.animation.ObjectAnimator.ofFloat
import android.animation.ValueAnimator
import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.core.content.ContextCompat
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.Adapter
import com.gingersoft.gsa.delivery_pick_mode.R
import com.gingersoft.gsa.delivery_pick_mode.data.model.bean.OrderListBean
import com.gingersoft.gsa.delivery_pick_mode.databinding.LayoutDeliveryOrderItemBinding
import com.scwang.smartrefresh.layout.util.SmartUtil.dp2px

class OrderListAdapter(var outTime: Int, var dataBean: List<OrderListBean> = ArrayList()) : Adapter<OrderListAdapter.ViewHolder>() {

    private var listener: ((item: OrderListBean) -> Unit)? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.layout_delivery_order_item, parent, false))
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val data = dataBean[position]
        holder.binding.data = data
        holder.binding.isSelf = data.orderType == 7
        if (data.orderType != 7 && data.isDelete == 0) {
            holder.binding.deliveryState = when (data.curStatNumber) {
                1 -> "已通知物流"
                2 -> "配送員已接單"
                3 -> "配送員到店附近"
                4 -> "配送員已到店"
                5 -> "配送中"
                6 -> "到達目的地附近"
                7 -> "訂單已完成"
                8 -> "物流已取消"//取餐前
                9 -> "物流已取消"//取餐後
                10 -> "已指派另一位配送員"
                else -> ""
            }
            if (data.curStatNumber < 2) {
                //是否超時
                if (outTime == 0) {
                    holder.binding.isTimeOut = false
                } else {
                    holder.binding.isTimeOut = data.timeSecond < outTime
                }
            }
        } else {
            holder.binding.deliveryState = ""
            holder.binding.isTimeOut = false
        }
        holder.binding.vehicle = when (data.transportationType) {
            1 -> ContextCompat.getDrawable(holder.itemView.context, R.drawable.ic_motorcycle)
            2 -> ContextCompat.getDrawable(holder.itemView.context, R.drawable.ic_bread_car)
            3 -> ContextCompat.getDrawable(holder.itemView.context, R.drawable.ic_truck)
            else -> null
        }
        var state: String? = null
        val bg = GradientDrawable()
        bg.cornerRadius = dp2px(5f).toFloat()
        holder.flBorder.visibility = View.GONE//隱藏邊框
        //執行動畫
        if (data.isRead == 0) {
            holder.flBorder.visibility = View.VISIBLE//顯示邊框
            alphaAnimator(holder.flBorder)
        } else {
            holder.flBorder.visibility = View.GONE
            holder.flBorder.clearAnimation()
        }
        when (data.status) {
            0 -> {
                state = "待確認"
                bg.setColor(getColor(holder.flBorder.context, R.color.order_state0_color))
            }
            1 -> {
                state = "待確認"
                bg.setColor(getColor(holder.flBorder.context, R.color.order_state0_color))
                holder.flBorder.visibility = View.VISIBLE//顯示邊框
            }
            2 -> {
                state = "製作中"
                bg.setColor(getColor(holder.flBorder.context, R.color.order_state1_color))
            }
            8 -> {
                state = "待製作"
                bg.setColor(getColor(holder.flBorder.context, R.color.order_state4_color))
                holder.flBorder.visibility = View.VISIBLE//顯示邊框
                alphaAnimator(holder.flBorder)
            }
            3 -> {
                state = if (data.orderType == 7) {
                    "待取餐"
                } else {
                    "派送中"
                }
                bg.setColor(getColor(holder.flBorder.context, R.color.order_state2_color))
            }
        }
        holder.binding.state = state
        holder.binding.stateBg = bg

        //堂食外賣背景
        val orderingMethodBg = GradientDrawable()
        orderingMethodBg.shape = GradientDrawable.RECTANGLE
        orderingMethodBg.cornerRadii = floatArrayOf(dp2px(8f).toFloat(), dp2px(8f).toFloat(), 0f, 0f, 0f, 0f, dp2px(8f).toFloat(), dp2px(8f).toFloat())

        holder.binding.orderingMethod =
                when (data.orderType) {
                    2 -> {
                        orderingMethodBg.setColor(getColor(holder.flBorder.context, R.color.order_state2_color))
                        "外送"
                    }
                    7 -> {
                        orderingMethodBg.setColor(getColor(holder.flBorder.context, R.color.order_state3_color))
                        "自取"
                    }
                    else -> {
                        orderingMethodBg.setColor(getColor(holder.flBorder.context, R.color.order_state1_color))
                        "堂食"
                    }
                }
        holder.binding.orderingMethodBg = orderingMethodBg

        //支付方式背景 data.orderPayType==1?@color/table_send:@color/table_use
        //data.orderPayType==1?@string/cash_on_delivery:@string/online_payments
        val payMethodBg = GradientDrawable()
        payMethodBg.cornerRadius = dp2px(10f).toFloat()
        holder.binding.payMethod =
                when (data.orderPayType) {
                    1 -> {
                        payMethodBg.setColor(getColor(holder.flBorder.context, R.color.cash_on_delivery_bg))
                        "貨到付款"
                    }
                    else -> {
                        payMethodBg.setColor(getColor(holder.flBorder.context, R.color.online_payments_bg))
                        "在線支付"
                    }
                }
        holder.binding.payMethodBg = payMethodBg

        holder.itemView.setOnClickListener {
            listener?.invoke(data)
        }

    }

    fun setOnItemClickListener(listener: (item: OrderListBean) -> Unit) {
        this.listener = listener
    }

    fun setData(dataBean: List<OrderListBean>) {
        this.dataBean = dataBean
        notifyDataSetChanged()
    }

    private fun alphaAnimator(view: View) {
        view.clearAnimation()
        val animatorSet = AnimatorSet()
        val ofFloat = ofFloat(view, "alpha", 0f, 1f)
        ofFloat.duration = 200
        ofFloat.repeatCount = -1
        ofFloat.repeatMode = ValueAnimator.REVERSE

        val ofFloat1 = ofFloat(view, "alpha", 1f, 0f)
        ofFloat1.duration = 200
        ofFloat1.repeatCount = -1
        ofFloat1.repeatMode = ValueAnimator.REVERSE

        animatorSet.play(ofFloat).with(ofFloat1)
        animatorSet.duration = 400
        animatorSet.start()
    }


    override fun getItemCount(): Int {
        return dataBean.size
    }

    private fun getColor(context: Context, color: Int): Int {
        return ContextCompat.getColor(context, color)
    }

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var binding: LayoutDeliveryOrderItemBinding = DataBindingUtil.bind(itemView)!!
        var flBorder: FrameLayout = itemView.findViewById(R.id.fl_border)
    }
}