package com.gingersoft.gsa.delivery_pick_mode.util

import android.app.Activity
import android.app.Dialog
import android.view.View
import androidx.annotation.ColorRes
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.RecyclerView
import com.gingersoft.gsa.cloud.ui.utils.AppDialog
import com.gingersoft.gsa.delivery_pick_mode.R

fun View.setState(state: Boolean) {
    visibility = if (state) {
        View.VISIBLE
    } else {
        View.GONE
    }
}


fun Activity.showWaringDialog(title: String, confirm: (Dialog) -> Unit, cancel: (Dialog) -> Unit) {
    AppDialog().showWaringDialog(this, title) { view, dialog ->
        when (view.id) {
            R.id.tv_dialog_confirm -> {
                confirm.invoke(dialog)
            }
            R.id.tv_dialog_cancel -> {
                cancel.invoke(dialog)
            }
        }
    }
}

fun Activity.showSelectDialog(title: String, spanCount: Int, adapter: RecyclerView.Adapter<RecyclerView.ViewHolder>, confirm: (Dialog) -> Unit, cancel: (Dialog) -> Unit) {
    AppDialog().showSelectDialog(this, title, spanCount, adapter) { view, dialog ->
        when (view.id) {
            R.id.tv_delivery_confirm -> {
                confirm.invoke(dialog)
            }
            R.id.tv_delivery_cancel -> {
                cancel.invoke(dialog)
            }
        }
    }
}

fun Activity.getCustomColor(@ColorRes colorId: Int): Int {
    return ContextCompat.getColor(this, colorId)
}

fun Fragment.getCustomColor(@ColorRes colorId: Int): Int {
    activity?.let {
        return ContextCompat.getColor(it, colorId)
    }
    return 0
}
