package com.gingersoft.gsa.cloud.table.di.module;


import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealStandContract;
import com.gingersoft.gsa.cloud.table.mvp.model.MealStandModel;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.SoldoutCtrFood;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.BillItemAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.ComboAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.DiscountAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.FoodAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.FoodGroupAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.ModifierAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.SelectMealAdapter;
import com.jess.arms.di.scope.ActivityScope;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;
import javax.inject.Named;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:17
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@Module
public abstract class MealStand2Module {

    @Binds
    abstract MealStandContract.Model bindMealStandModel(MealStandModel model);

    @ActivityScope
    @Provides
    @Named("foodGroupList")
    static List<Food> provideFoodGroupList() {
        return new ArrayList<>();
    }

    @ActivityScope
    @Provides
    @Named("foodList")
    static List<Food> provideFoodList() {
        return new ArrayList<>();
    }

    @ActivityScope
    @Provides
    static List<ComboItem> provideFoodCombo() {
        return new ArrayList<>();
    }

    @ActivityScope
    @Provides
    static List<Modifier> provideModifierList() {
        return new ArrayList<>();
    }

    @ActivityScope
    @Provides
    static List<Discount> provideDiscountList() {
        return new ArrayList<>();
    }

    @ActivityScope
    @Provides
    static List<SoldoutCtrFood> provideSoldoutCtrList() {
        return new ArrayList<>();
    }

    @Inject
    protected SelectMealAdapter mSelectMealAdapter;
    /**
     * 賬單項適配器
     */
    @Inject
    protected BillItemAdapter mBillItemAdapter;

    @ActivityScope
    @Provides
    static FoodAdapter provideFoodAdapter(MealStandContract.View IView, @Named("foodList") List<Food> foodList) {
        return new FoodAdapter(IView.getActivity(), foodList, IView.getFromType());
    }

    @ActivityScope
    @Provides
    static ComboAdapter provideComboAdapter(MealStandContract.View IView, List<ComboItem> comboItemList) {
        return new ComboAdapter(IView.getActivity(), comboItemList);
    }

    @ActivityScope
    @Provides
    static ModifierAdapter provideModifierAdapter(MealStandContract.View IView, List<Modifier> modifierList) {
        return new ModifierAdapter(IView.getActivity(), modifierList);
    }

    @ActivityScope
    @Provides
    static DiscountAdapter provideDiscountAdapter(MealStandContract.View IView, List<Discount> discountList) {
        return new DiscountAdapter(IView.getActivity(), discountList);
    }

}